/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import gl4java.*;
import gl4java.awt.*;
import java.awt.*;
import java.awt.event.*;

/**
 * A frame where you can render 3D scene.
 * 
 * @author Artiste on the Web
 */

public class RenderingFrame extends java.awt.Frame implements RenderingSurface {
  /**
   * Creates a rendering frame with the given size. The given size correspond to the
   * size of the rendering surface, not to the size of the frame.
   * @param width  the surface width in pixel
   * @param height the surface height in pixel
   */
  public RenderingFrame(int width, int height) { this("soya : rendering window", width, height); }  
  /**
   * Creates a rendering frame with the given title and size. The given size correspond to
   * the size of the rendering surface, not to the size of the frame.
   * @param title  the frame title
   * @param width  the surface width in pixel
   * @param height the surface height in pixel
   */
  public RenderingFrame(String title, int width, int height) {
    super(title);
    c = new RenderingCanvas(width, height);
    add(c);
    Insets i = getInsets();
    setBounds(50, 50, i.left + i.right + width, i.top + i.bottom + height);
  }
  
  public void dispose() {
    c.dispose();
    super.dispose();
  }

  private RenderingCanvas c;
  public void display() { c.display(); }
  
  public Renderer getRenderer() { return c.getRenderer(); }
  public GLContext getGLContext() { return c.getGLContext(); }
  public void setRenderer(Renderer r) { 
    c.setRenderer(r);
    firePropertyChange("renderer", null, null);
  }

  protected void makeCurrent() { c.makeCurrent(); }
  protected void makeSwap() { c.makeSwap(); }
  
  public void addOverlay(Overlay o) { c.addOverlay(o); }
  public void removeOverlay(Overlay o) { c.removeOverlay(o); }
  
  public void showFPS() { c.showFPS(); }
  
  // Override :
  public void createGLContext() {
    setVisible(true);
    do {  } while(!(c.cvsIsInit() || (c.getGLContext() != null)));
  }

  public void render() { c.render(); }
  public void repaint() {
    super.repaint();
    c.repaint();
  }
  public void addKeyListener(KeyListener l) {
		super.addKeyListener(l);
		c.addKeyListener(l);
  }
  public void removeKeyListener(KeyListener l) {
		super.removeKeyListener(l);
		c.removeKeyListener(l);
  }
  
  public int getSurfaceWidth () { return c.getWidth (); }
  public int getSurfaceHeight() { return c.getHeight(); }
}
