/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.awt;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.Renderer;
import gl4java.*;
import java.util.*;

/**
 * A rectangular part of a rendering surface, used as an entire rendering surface.
 * 
 * @author Artiste on the Web
 */

public class RenderingPanelComponent extends Object implements RenderingSurfacePart {
  public RenderingPanelComponent(RenderingMultipleSurface rs) {
    panel = rs;
  }
  public RenderingPanelComponent(RenderingMultipleSurface rs, float left, float top, float width, float height) {
    this(rs);
    setViewport(left, top, width, height);
  }
  
  protected RenderingMultipleSurface panel;
  public RenderingMultipleSurface getRenderingMultipleSurface() { return panel; }
  
  public void dispose() {
    panel.removeComponent(this);
  }
  
  protected Renderer renderer;
  public Renderer getRenderer() { return renderer; }
  public void setRenderer(Renderer r) {
    renderer = r;
    renderer.setRenderingSurface(this);
  }
  
  protected float left, top, width = 1f, height = 1f;
  public float getViewportLeft  () { return left  ; }
  public float getViewportTop   () { return top   ; }
  public float getViewportWidth () { return width ; }
  public float getViewportHeight() { return height; }
  public int getSurfaceWidth () { return (int) (width  * (float) panel.getSurfaceWidth ()); }
  public int getSurfaceHeight() { return (int) (height * (float) panel.getSurfaceHeight()); }
  public void setViewportLeft  (float i) {
    left   = i;
    resized = true;
  }
  public void setViewportTop   (float i) {
    top    = i;
    resized = true;
  }
  public void setViewportWidth (float i) {
    width  = i;
    resized = true;
  }
  public void setViewportHeight(float i) {
    height = i;
    resized = true;
  }
  public void setViewport(float l, float t, float w, float h) {
    left   = l;
    top    = t;
    width  = w;
    height = h;
    resized = true;
  }
  
  private boolean visible;
  public boolean isVisible() { return visible; }
  public void setVisible(boolean b) {
    if(b == visible) return;
    visible = b;
    if(visible) {
      panel.addComponent(this);
    }
    else {
      panel.removeComponent(this);
    }
  }
  
  public GLContext getGLContext() { return panel.getGLContext(); }
  public void createGLContext() { panel.createGLContext(); }
  
  protected boolean resized;
  public void makeViewportCurrent(GLFunc gl) {
    gl.glViewport((int) (left   * panel.getSurfaceWidth ()),
                  (int) (top    * panel.getSurfaceHeight()),
                  (int) (width  * panel.getSurfaceWidth ()),
                  (int) (height * panel.getSurfaceHeight()));
    resized = false;
  }
  public void render(GLFunc gl, GLUFunc glu) {
    renderer.render();
    if(!overlays.isEmpty()) {
      Quality.makeOverlaysCurrent(gl, glu, this);
      for(Iterator i = overlays.iterator(); i.hasNext(); ) ((Overlay) i.next()).draw(gl, glu);
      Quality.unmakeOverlaysCurrent(gl, glu, this);
    }
  }
  public void render() {
    if(visible) panel.render(this);
  }
  
  // Overlays support :
  private java.util.Collection overlays = new java.util.Vector();
  public void addOverlay(Overlay o) {
    if(!overlays.contains(o)) overlays.add(o);
  }
  public void removeOverlay(Overlay o) { overlays.remove(o); }
  
  /**
   * Shows, at the left bottom corner, the FPS (frame per second) rate. It mesures
   * rendering the speed.
   * @return the fps overlay.
   */
  public FPSOverlay showFPS() { return FPSOverlay.newFPSOverlay(this); }
}
