/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.font.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;

/**
 * A shape element that draws the 3 axis. It is used by the GUIEditor.
 * 
 * @author Artiste on the Web
 */

public class Axis3D extends FixedFragmentElement3D {
  /**
   * Create a 3-axis-element.
   */
  public Axis3D() { super(); }
  /**
   * Create a 3-axis-element with the given name.
   * @param name the name
   */
  public Axis3D(String name) { super(name); }

  public Object clone() {
    return new Axis3D(); // No property so it's OK.
  }
  
  public float getNaturalWidth () { return 1f; }
  public float getNaturalHeight() { return 1f; }
  public float getNaturalDepth () { return 1f; }
  public DimensionWrapper wrapper() { return new Box(new Point(0f, 0f, 0f, this), new Point(1f, 1f, 1f, this), this); }
  
  public Material getMaterial() { return Material.WHITE_MATERIAL; }
  
  private static final Font2D font = DefaultFont2D.HELVETICA_10;
  private static final float[] VIOLET = { 1f, 0f, 1f, 1f };

  /** draw the fragmentin the given gl and glu. */
  public void fixedDraw(GLFunc gl, GLUFunc glu) {
    gl.glMaterialfv(GLEnum.GL_FRONT_AND_BACK, GLEnum.GL_AMBIENT_AND_DIFFUSE, VIOLET);
    
    gl.glBegin(GLEnum.GL_LINES); // X
    gl.glVertex3f(.999f, 0f, 0f); // .999 and not 1 because 1 may crash Mesa (a line with a bound just at the bottom or top limit of the screen crash Mesa).
    gl.glVertex3f(0f, 0f, 0f);
    gl.glEnd();
    
    gl.glBegin(GLEnum.GL_LINES); // Y
    gl.glVertex3f(0f, .999f, 0f);
    gl.glVertex3f(0f, 0f, 0f);
    gl.glEnd();
    
    gl.glBegin(GLEnum.GL_LINES); // Z
    gl.glVertex3f(0f, 0f, .999f);
    gl.glVertex3f(0f, 0f, 0f);
    gl.glEnd();
    
    font.draw(gl, glu, "0", 0f, 0f, 0f);
    font.draw(gl, glu, "Y", 0f, 1f, 0f);
    font.draw(gl, glu, "Z", 0f, 0f, 1f);
    font.draw(gl, glu, "X", 1f, 0f, 0f);
    
    gl.glMaterialfv(GLEnum.GL_FRONT_AND_BACK, GLEnum.GL_AMBIENT_AND_DIFFUSE, Material.WHITE_COLOR); // Must be reseted to default for Material.NO_MATERIAL.
  }
}
