/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import java.beans.*;
import java.awt.*;

/**
 * Property editor for name property.
 * 
 * @author Artiste on the Web
 */

public class FileNameEditor extends PropertyEditorSupport {
  public FileNameEditor () { super(); }
  
  public boolean supportsCustomEditor() { return true; }
  
  private Component customEditor;
  /**
   * Recovers the custom editor.
   * @return the custom editor
   */
  public Component getCustomEditor() {
    if(customEditor == null) customEditor = new PropertyFileName(this);
    return customEditor;
  }
}
