/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

class PropertyCanvas extends Canvas implements MouseListener {
  PropertyCanvas(Frame frame, PropertyEditor pe) {
    this.frame = frame;
    editor = pe;
    addMouseListener(this);
  }

  public void paint(Graphics g) {
    Rectangle box = new Rectangle(2, 2, getSize().width - 4, getSize().height - 4);
    editor.paintValue(g, box);
  }

  private static boolean ignoreClick = false;
  private Frame frame;
  private PropertyEditor editor;

  public void mouseClicked(MouseEvent e) {
    if(!ignoreClick) {
      try {
        ignoreClick = true;
        int x = frame.getLocation().x - 30;
        int y = frame.getLocation().y + 50;
        new PropertyDialog(frame, editor, x, y);
      }
      finally { ignoreClick = false; }
    }
  }
  public void mousePressed(MouseEvent e) {  }
  public void mouseReleased(MouseEvent e) {  }
  public void mouseEntered(MouseEvent e) {  }
  public void mouseExited(MouseEvent e) {  }
}
