/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

class PropertyDialog extends Dialog implements ActionListener {
  PropertyDialog(Frame frame, PropertyEditor pe, int x, int y) {
  	super(frame, pe.getClass().getName(), true);
	  new WindowCloser(this);
	  setLayout(null);

	  body = pe.getCustomEditor();
	  add(body);

	  doneButton = new Button("Done");
	  doneButton.addActionListener(this);
	  add(doneButton);

	  setLocation(x, y);
	  show();
  }

  private Button doneButton;
  private Component body;
  private final static int vPad = 5;
  private final static int hPad = 4;


  public void actionPerformed(ActionEvent evt) { dispose(); }

  public void doLayout() {
    Insets ins = getInsets();
	  Dimension bodySize = body.getPreferredSize();
	  Dimension buttonSize = doneButton.getPreferredSize();

	  int width = ins.left + 2 * hPad + ins.right + bodySize.width;
	  int height = ins.top + 3 * vPad + ins.bottom + bodySize.height + buttonSize.height;

    body.setBounds(ins.left+hPad, ins.top+vPad, bodySize.width, bodySize.height);
  	doneButton.setBounds((width-buttonSize.width)/2, ins.top+(2*hPad) + bodySize.height, buttonSize.width, buttonSize.height);
  	setSize(width, height);
  }
}

