/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import java.beans.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/**
 * A "edit..." button that edits the property when clicked. If the property editor is an
 * EditableEditor, it call is editProperty() method, else standard bean edition is used.
 * 
 * @author Artiste on the Web
 */

public class PropertyEditButton extends Button implements ActionListener {
  public PropertyEditButton(PropertyEditor pe) {
    super("Edit...");
    editor = pe;
    addActionListener(this);
  }
  
  private PropertyEditor editor;
  
  public void actionPerformed(ActionEvent e) {
    if(editor instanceof EditableEditor) ((EditableEditor) editor).editProperty();
    else {
      try { Editor.edit(editor.getValue()); }
      catch(Exception ex) { ex.printStackTrace(); }
    }
  }
}
