/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class PropertySubPropertyWriteOnly extends Container implements ActionListener, ItemListener {
  public PropertySubPropertyWriteOnly(PropertyEditor pe) {
    editor = pe;
  	
    c = new Choice();
    String[] tags = editor.getTags();
    c.addItem(WRITE_ONLY_TEXT);
    for (int i = 0; i < tags.length; i++) c.addItem(tags[i]);
    c.select(0);
    add(c);
    c.addItemListener(this);
		
    b = new Button("edit");
    add(b);
    b.addActionListener(this);
	  
    setLayout(new FlowLayout(FlowLayout.LEFT, 0, 0));
    doLayout();
  }
  
  protected static final String WRITE_ONLY_TEXT = "(write only)";
  
  private PropertyEditor editor;
  private Choice c;
  private Button b;
  
  public synchronized void actionPerformed(ActionEvent e) {
    Object o = editor.getValue();
    if(o != null) {
      try { Editor.edit(o); }
      catch(Exception e2) { System.out.println("Can't edit " + editor); e2.printStackTrace(); }
    }
  }
  
  public synchronized void itemStateChanged(ItemEvent e) {
    String s = c.getSelectedItem();
    if(!WRITE_ONLY_TEXT.equals(s)) {
      editor.setAsText(s);
      c.select(0);
    }
  }
  
  public synchronized void repaint() { c.select(0); }
}
