/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class PropertyText extends TextField implements KeyListener, FocusListener {
  public PropertyText(PropertyEditor pe) {
    super(pe.getAsText());
    editor = pe;
    addKeyListener(this);
    addFocusListener(this);
  }

  private PropertyEditor editor;

  public void repaint() { setText(editor.getAsText()); }

  protected void updateEditor() {
    try { editor.setAsText(getText()); }
    catch (IllegalArgumentException ex) {  }
  }
    
  public void focusGained(FocusEvent e) {  }
  public void focusLost(FocusEvent e) { updateEditor(); }
    
  public void keyPressed(KeyEvent e) {  }
  public void keyTyped(KeyEvent e) {  }
  public void keyReleased(KeyEvent e) {
    if (e.getKeyCode() == KeyEvent.VK_ENTER) updateEditor();
  }
}
