/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.util.*;
import java.io.*;
import java.awt.*;
import java.awt.List;
import java.awt.event.*;

/**
 * Demands to the user to choose a pathed object in a list of all pathed objects in their path.
 * 
 * @author Artiste on the Web
 */

public class StoredInPathObjectChooser extends Dialog implements ActionListener {
  /**
   * Creates a new pathed object chooser.
   * @param owner the owner frame
   * @param path the path that contains the pathed object
   * @param extension the file name extension of this class of pathed objects
   * @param addNull if true, add a "null" line to the list
   */
  public StoredInPathObjectChooser(Frame owner, String path, String extension, boolean addNull) {
    super(owner, "Choose a " + extension, true);
    setLayout(new BorderLayout());
    
    File[] f = (new File(path)).listFiles();
    if(addNull) l.add(NO_STRING);
    java.util.Arrays.sort(f, new java.util.Comparator() {
      public int compare(Object o1, Object o2) { return ((File) o1).getName().compareTo(((File) o2).getName()); }
      public boolean equals(Object o) { return o.getClass() == getClass(); }
    });
    for(int i = 0; i < f.length; i++) {
      String filename = f[i].getName();
      l.add(filename.substring(0, filename.length() - extension.length() - 1));
    }
    l.addActionListener(this);
    add(l);
    		
    b.addActionListener(this);
    add(b, BorderLayout.SOUTH);
    
    setSize(300, 500);
  }
  
  public void actionPerformed(ActionEvent e) {
    choice = l.getSelectedItem();
    if(choice == null) return;
    if(choice.equals(NO_STRING)) choice = null;
    dispose();
  }
  /**
   * Gets the choosen pathed object name.
   * @return the name ("(null)" for null).
   */
  public String getChoice() { return choice; }
  
  private List l = new List();
  private Button b = new Button("OK");
  private String choice;
  protected static final String NO_STRING    = "(null)"   ;   // value is null.
  
  public static String question(Frame owner, String path, String extension, boolean addNull) {
    StoredInPathObjectChooser poc = new StoredInPathObjectChooser(owner, path, extension, addNull);
    poc.setVisible(true);
    return poc.getChoice();
  }
}
