/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import java.beans.*;
import java.awt.*;
import java.io.*;

/**
 * Abstract editor for pathed object.
 * 
 * @author Artiste on the Web
 */

public abstract class StoredInPathObjectEditorWriteOnly extends PropertyEditorSupport {
  public String getAsText() { // Write only.
    return PropertySubPropertyWriteOnly.WRITE_ONLY_TEXT;
  }
  public void setAsText(String t) throws IllegalArgumentException {
    if(t.equals(   NO_STRING)) { setValue(getNull ( )); return; }
    if(t.equals(OTHER_STRING)) { setValue(getNew  ( )); return; }
    if(t.equals( LIST_STRING)) { setValue(list    ( )); return; }
                                 setValue(getNamed(t));
  }
  
  /**
   * Should return the null value for this type of property. Default is null.
   * Override this method if you want another value.
   * @return the null value.
   */
  protected          StoredInPathObject getNull () { return null; }
  /**
   * Should return a new object for this type of property.
   * Override this method and create a new instance of your pathed object.
   * @return a new object.
   */
  protected abstract StoredInPathObject getNew  ();
  /**
   * Should return the object corresponding to the given name.
   * Override this method and return this object.
   * @param name the name of the desired pathedObject.
   * @return the null value.
   */
  protected abstract StoredInPathObject getNamed(String name);
  /**
   * Should show a dialog box with a list, and returns the user's choice. This is designed
   * for the case where all the choices doesn't fit inside the screen.
   * Override this method.
   * @return the stored in path object choosen.
   */
  protected abstract StoredInPathObject list();
  
  protected static final String NO_STRING    = "(null)"   ;   // value is null.
  protected static final String LIST_STRING  = "(list...)";  // shows a dialog box.
  protected static final String OTHER_STRING = "(other)"  ; // value is not saved in the path.
  protected static String[] computeTags(String path, String fileExtension) {
    int extensionSize = fileExtension.length();
    File[] f = (new File(path)).listFiles();
    java.util.Arrays.sort(f, new java.util.Comparator() {
      public int compare(Object o1, Object o2) { return ((File) o1).getName().compareTo(((File) o2).getName()); }
      public boolean equals(Object o) { return o.getClass() == getClass(); }
    });
    int flength = f.length;
    
    String[] tags = new String[f.length + 3];
    tags[0] = NO_STRING;
    tags[1] = LIST_STRING;
    tags[2] = OTHER_STRING;
    for(int i = 0; i < f.length; i++) {
      String filename = f[i].getName();
      tags[i + 3] = filename.substring(0, filename.length() - extensionSize);
    }
    return tags;
  }
  
  public boolean supportsCustomEditor() { return true; }
  private Component customEditor;
  public Component getCustomEditor() { // A pathedObject IS a sub property, so we can reuse the same custom editor than for SubPropertyEditor.
    if(customEditor == null) customEditor = new PropertySubPropertyWriteOnly(this);
    return customEditor;
  }
}
