/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import java.beans.*;
import java.awt.*;
import java.util.*;

/**
 * An abstract class for tagged property editor, where each tag is associated to a value.
 * 
 * You must extends this class to use it, and add the right tags in a constructor, with the
 * addTag method.
 * 
 * See soya.soya3d.model.VisibilityPropertyEditor for an example.
 * 
 * @author Artiste on the Web
 */

public abstract class TaggedPropertyEditor extends PropertyEditorSupport {
  /**
   * Creates a new tagged property editor.
   */
  public TaggedPropertyEditor() { super(); }

  private Map tags = new HashMap();
  /**
   * Gets the tags.
   * @return the tags
   */
  public String[] getTags() { return (String[]) tags.keySet().toArray(new String[0]); }

  /**
   * Adds a tags. Can be used, for example, in the constructor of a child class.
   * @param tag   the tag
   * @param value the tag value
   */
  protected void addTag(String tag, int value) { addTag(tag, new Integer(value)); }
  /**
   * Adds a tags. Can be used, for example, in the constructor of a child class.
   * @param tag   the tag
   * @param value the tag value
   */
  protected void addTag(String tag, Object value) { tags.put(tag, value); }
  /**
   * Removes a tags.
   * @param tag   the tag
   */
  protected void removeTag(String tag) { tags.remove(tag); }

  /**
   * Gets the selected tag.
   * @return the selected tag
   */
  public synchronized String getAsText() {
    for(Iterator i = tags.entrySet().iterator(); i.hasNext(); ) {
      Map.Entry e = (Map.Entry) i.next();
      if(e.getValue().equals(getValue())) return (String) e.getKey();
    }
    return "(invalid tag)";
  }
  /**
   * Sets the property to the value associated with the given tag.
   * @param the tag
   */
  public synchronized void setAsText(String tag) throws IllegalArgumentException {
    try { setValue(tags.get(tag)); }
    catch(Exception e) { throw new IllegalArgumentException("Can't set this property to this tag : " + tag); }
  }
}
