/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import opale.soya.util.*;
import java.io.*;
import java.awt.*;
import java.awt.List;
import java.awt.event.*;

/**
 * Demands to the user to choose a class.
 * 
 * @author Artiste on the Web
 */

public class TextChooser extends Dialog implements ActionListener {
  /**
   * Creates a new class chooser.
   * @param owner the owner frame
   */
  public TextChooser(Frame owner, String title, String defaultText) {
    super(owner, title, true);
    setLayout(new BorderLayout());
    
    t.setText(defaultText);
    add(t);
    
    b.addActionListener(this);
    add(b, BorderLayout.SOUTH);
    
    t.requestFocus();
    
    setSize(200, 100);
  }
  
  public void actionPerformed(ActionEvent e) { dispose(); }
  
  /**
   * Gets the choosen class.
   * @return the class.
   */
  public String getChoice() {
    return t.getText();
  }
  
  private TextField t = new TextField();
  private Button b = new Button("OK");
  
  public static String question(Frame owner, String title, String defaultText) {
    TextChooser tc = new TextChooser(owner, title, defaultText);
    tc.setVisible(true);
    return tc.getChoice();
  }
  public static String question(Frame owner, String title) {
    return question(owner, title, "");
  }
}
