/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.editor;

import opale.soya.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Arrays;
import java.util.Comparator;

/**
 * A dialog box that ask for a yes/no/cancel question : with a yes, a no and a cancel button.
 * 
 * @author Artiste on the Web
 */

public class YesNoCancelDialog extends Dialog {
  /**
   * Creates a new yes/no/cancel dialog box.
   * @param owner the owner frame
   * @param title the title
   * @param text  the question
   */
  public YesNoCancelDialog(Frame owner, String title, String text) {
    super(owner, title, true);

    setLayout(new GridLayout(4, 1));

    add(new Label(text));

    yes = new Button("Yes");
    yes.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
        answer = YES;
      }
    });
    add(yes);

    no = new Button("No");
    no.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
        answer = NO;
      }
    });
    add(no);

    cancel = new Button("Cancel");
    cancel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        dispose();
        answer = CANCEL;
      }
    });
    add(cancel);

    setSize(500, 150);
  }
  /** Constant for a positive anwser */ public static int YES    = 1;
  /** Constant for a negative anwser */ public static int NO     = 2;
  /** Constant for a cancel anwser   */ public static int CANCEL = 0;
  private Button yes;
  private Button no;
  private Button cancel;
  private int answer;
  /**
   * Gets the anwer.
   * @return a symbolic constant
   */
  public int getAnswer() { return answer; }

  /**
   * Ask a yes/no/cancel question.
   * @param owner the owner frame
   * @param text  the question
   * @return a symbolic constant
   */
  public static int question(Frame owner, String text) { return question(owner, text, text); }
  /**
   * Ask a yes/no/cancel question.
   * @param owner the owner frame
   * @param title the title
   * @param text  the question
   * @return a symbolic constant
   */
  public static int question(Frame owner, String title, String text) {
    YesNoCancelDialog yesNoCancel = new YesNoCancelDialog(owner, title, text);
    yesNoCancel.setVisible(true);
    return yesNoCancel.answer;
  }
}
