/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.font;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import java.beans.*;
import java.awt.*;
import java.io.*;

/**
 * Editor for 2D font.
 * 
 * @author Artiste on the Web
 */

public class Font2DEditor extends PropertyEditorSupport {
  public String getAsText() { return ((Font2D) getValue()).getDescription(); }
  public void setAsText(String t) throws IllegalArgumentException {
    setValue(DefaultFont2D.getFont(t));
  }
  
  private static String[] tags;
  public String[] getTags() {
    if(tags == null) {
      tags = new String[7];
      tags[0] = DefaultFont2D.BITMAP_8_13.getDescription();
      tags[1] = DefaultFont2D.BITMAP_9_15.getDescription();
      tags[2] = DefaultFont2D.HELVETICA_10.getDescription();
      tags[3] = DefaultFont2D.HELVETICA_12.getDescription();
      tags[4] = DefaultFont2D.HELVETICA_18.getDescription();
      tags[5] = DefaultFont2D.TIMES_ROMAN_10.getDescription();
      tags[6] = DefaultFont2D.TIMES_ROMAN_24.getDescription();
    }
    return tags;
  }
}
