/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.util.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class MaterialBeanInfo extends AbstractBeanInfo {
  public MaterialBeanInfo() {
    super(true, false, false);

    PropertyDescriptor[] pd = new PropertyDescriptor[18];
    try {
      pd[0] = new PropertyDescriptor("specular", getBeanClass());
      pd[0].setHidden(true);
      pd[1] = new PropertyDescriptor("diffuse", getBeanClass());
      pd[1].setHidden(true);
      pd[2] = new PropertyDescriptor("shininess", getBeanClass());
      pd[3] = new PropertyDescriptor("useAlpha", getBeanClass(), "getUseAlpha", null);
      pd[3].setHidden(true);
      pd[4] = new PropertyDescriptor("texture", getBeanClass());
      pd[5] = new PropertyDescriptor("name", getBeanClass());
      pd[5].setPropertyEditorClass(opale.soya.util.NameEditor.class);
      pd[6] = new PropertyDescriptor("diffuseRed", getBeanClass());
      pd[7] = new PropertyDescriptor("diffuseGreen", getBeanClass());
      pd[8] = new PropertyDescriptor("diffuseBlue", getBeanClass());
      pd[9] = new PropertyDescriptor("diffuseAlpha", getBeanClass());
      pd[10] = new PropertyDescriptor("specularRed", getBeanClass());
      pd[11] = new PropertyDescriptor("specularGreen", getBeanClass());
      pd[12] = new PropertyDescriptor("specularBlue", getBeanClass());
      pd[13] = new PropertyDescriptor("specularAlpha", getBeanClass());
      pd[14] = new PropertyDescriptor("wireframed", getBeanClass());
      pd[15] = new PropertyDescriptor("overlayed", getBeanClass());
      pd[16] = new PropertyDescriptor("separateSpecular", getBeanClass());
      pd[17] = new PropertyDescriptor("blending", getBeanClass());
      pd[17].setPropertyEditorClass(opale.soya.soya2d.BlendingPropertyEditor.class);
      /*
      pd[17] = new PropertyDescriptor("logicOp", getBeanClass());
      pd[17].setPropertyEditorClass(opale.soya.soya2d.LogicOpPropertyEditor.class);
      */
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }
  
  public BeanDescriptor getBeanDescriptor() {
    return new BeanDescriptor(opale.soya.soya2d.Material.class, opale.soya.soya2d.MaterialCustomizer.class);
  }
}
