/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import gl4java.*;
import gl4java.utils.textures.*;
import java.util.*;
import java.awt.*;
import java.io.*;

/**
 * A texture that has no transparency.
 *
 * @author Artiste on the Web
 */

public class TextureFromPNG extends Texture {
  //private static final long serialVersionUID = -716752221597623239l;
  
  /**
   * Creates a new texture.
   */
  public TextureFromPNG() {  }
  /**
   * Creates a new texture from the given PNG image file name. The file is understood to be
   * in the material path.
   * @param fileName the image file name
   */
  public TextureFromPNG(String PNGName) throws InterruptedException { setImageFileName(PNGName); }
  
  public Object clone() {
    try {
      return new TextureFromPNG(imageFileName);
    }
    catch(Exception e) { e.printStackTrace(); return null; }
  }
  
  public boolean getUseAlpha() { return false; }
  public boolean isTransparent() { return false; }
  
  protected transient byte[] myData = new byte[0];
  public byte[] getImageData() { return myData; }
  
  protected byte[] computeImageToData(java.awt.Image i) throws InterruptedException {
    return dataFromImageRGB(i);
  }
  public synchronized void setImageFileName(String fileName) throws InterruptedException {
    imageFileName = fileName;
    System.out.println("imageFileName changed");
    reBuild();
    firePropertyChange("imageFileName");
  }
  public synchronized String getPNGName() { return imageFileName; }
  public synchronized void setPNGName(String PNGName) {
    imageFileName = PNGName;
    reBuild();
    firePropertyChange("imageFileName");
  }
  
  // Overrides :
  protected synchronized void build(GLFunc gl, GLUFunc glu) {
    PngTextureLoader png = new PngTextureLoader(gl, glu);
    png.readTexture(Material.path + imageFileName);
    myData = png.getTexture();

    super.build(gl, glu);
    gl.glPixelStorei(GLEnum.GL_UNPACK_ALIGNMENT, 1);
    gl.glTexImage2D(GLEnum.GL_TEXTURE_2D, 0, GLEnum.GL_RGB, png.getTextureWidth(), png.getTextureHeight(), 0, GLEnum.GL_RGB, GLEnum.GL_UNSIGNED_BYTE, myData);     // Optimizable : RGBA quicker than RGB ?
    
    int error = gl.glGetError();
    if(error != 0) throw (RuntimeException) (new GLErrorException("Error while building texture RGB :" + Integer.toString(error)));
  }
  public void makeCurrent(GLFunc gl, GLUFunc glu) {
    if(!isBuilt) build(gl, glu);
    if(!gl.glIsEnabled(GLEnum.GL_TEXTURE_2D)) gl.glEnable(GLEnum.GL_TEXTURE_2D);
    gl.glBindTexture(GLEnum.GL_TEXTURE_2D, id);
  }
  /*
  public void makeCurrent(GLFunc gl, GLUFunc glu) {
    build(gl, glu);
    super.makeCurrent(gl, glu);
  }
  */
}
