/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.awt.*;
import gl4java.*;
import java.util.*;
import java.awt.*;
import java.io.*;

/**
 * A texture that has no transparency.
 *
 * @author Artiste on the Web
 */

public class TextureRGB extends Texture {
  private static final long serialVersionUID = -716752221597623239l;
  
  /**
   * Creates a new texture.
   */
  public TextureRGB() {  }
  /**
   * Creates a new texture from the given image.
   * @param i the awt image
   */
  public TextureRGB(java.awt.Image i) throws InterruptedException { setImage(i); }
  /**
   * Creates a new texture from the given image file name (gif for example).
   * @param fileName the image file name
   */
  public TextureRGB(String fileName) throws InterruptedException { setImageFileName(fileName); }
  
  public Object clone() {
    try {
      if((imageFileName == null) || (imageFileName.equals(""))) return new TextureRGB(getImage());
      else return new TextureRGB(imageFileName);
    }
    catch(Exception e) { e.printStackTrace(); return null; }
  }
  
  public boolean getUseAlpha() { return false; }
  public boolean isTransparent() { return false; }

  protected byte[] computeImageToData(java.awt.Image i) throws InterruptedException { return dataFromImageRGB(i); }
  
  // Overrides :
  protected synchronized void build(GLFunc gl, GLUFunc glu) {
    int error0 = gl.glGetError();
    if(error0 != 0) System.out.println("Error before building texture RGB :" + error0 + " : " + glu.gluErrorString(error0));

    super.build(gl, glu);
    gl.glPixelStorei(GLEnum.GL_UNPACK_ALIGNMENT, 1);
    if(Quality.useMipmaps)
      glu.gluBuild2DMipmaps(GLEnum.GL_TEXTURE_2D, GLEnum.GL_RGB, getWidth(), getHeight(), GLEnum.GL_RGB, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    else
      gl.glTexImage2D(GLEnum.GL_TEXTURE_2D, 0, GLEnum.GL_RGB, getWidth(), getHeight(), 0, GLEnum.GL_RGB, GLEnum.GL_UNSIGNED_BYTE, getImageData());     // Optimizable : RGBA quicker than RGB ?
    
    //Soya.checkError(gl, glu, "Building texture RGB :");
    int error = gl.glGetError();
    if(error != 0) System.out.println("Error while building texture RGB :" + error + " : " + glu.gluErrorString(error));
  }
  
  /*
  public void draw(GLFunc gl, GLUFunc glu, int x, int y) { // Optimizable.
    gl.glRasterPos2d(x, y);
    gl.glDrawPixels(getWidth(), getHeight(), GLEnum.GL_RGB, GLEnum.GL_UNSIGNED_BYTE, getImageData());
  }
  public void draw(GLFunc gl, GLUFunc glu, int x, int y, int width, int height) { // Optimizable.
    int w = getWidth(), h = getHeight();
    gl.glRasterPos2d(x, y);
    gl.glPixelZoom(((float) width) / ((float) w), ((float) height) / ((float) h));
    gl.glDrawPixels(w, h, GLEnum.GL_RGB, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    gl.glPixelZoom(1f, 1f);
  }
  */
}
