/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.awt.*;
import gl4java.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * A texture that has transparency with alpha blending (semi-transparency).
 *
 * The mask should have only black, white and gray pixels.
 *
 * @author Artiste on the Web
 */

public class TextureRGBA extends MaskedTexture {
  /**
   * Creates a new texture.
   */
  public TextureRGBA() {  }
  /**
   * Creates a new texture from the given image.
   * @param i the awt image
   */
  public TextureRGBA(java.awt.Image image, java.awt.Image mask) throws InterruptedException {
    setImage(image);
    setMask (mask );
  }
  /**
   * Creates a new texture from the given image file name (gif for example).
   * @param fileName the image file name
   */
  public TextureRGBA(String imageFileName, String maskFileName) throws InterruptedException {
    setImageFileName(imageFileName);
    setMaskFileName (maskFileName );
  }
  
  public Object clone() {
    try {
      if((imageFileName == null) || (imageFileName.equals(""))) return new TextureRGBA(getImage(), getMask());
      else return new TextureRGBA(imageFileName, maskFileName);
    }
    catch(Exception e) { e.printStackTrace(); return null; }
  }

  public boolean getUseAlpha() { return true; }
  public boolean isTransparent() { return true; }

  protected synchronized void build(GLFunc gl, GLUFunc glu) {
    super.build(gl, glu);
    gl.glPixelStorei(GLEnum.GL_UNPACK_ALIGNMENT, 1);
    if(Quality.useMipmaps)
      glu.gluBuild2DMipmaps(GLEnum.GL_TEXTURE_2D, GLEnum.GL_RGBA, getWidth(), getHeight(), GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    else
      gl.glTexImage2D(GLEnum.GL_TEXTURE_2D, 0, GLEnum.GL_RGBA, getWidth(), getHeight(), 0, GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());

    Soya.checkError(gl, glu, "Building texture RGBA :");
  }
  
  /*
  public void draw(GLFunc gl, GLUFunc glu, int x, int y) {
    draw(gl, glu, x, y, getWidth(), getHeight());
    gl.glEnable(GLEnum.GL_BLEND);
    gl.glRasterPos2d(x, y);
    gl.glDrawPixels(getWidth(), getHeight(), GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    gl.glDisable(GLEnum.GL_BLEND);
  }
  public void draw(GLFunc gl, GLUFunc glu, int x, int y, int width, int height) {
    int w = getWidth(), h = getHeight();
    gl.glEnable(GLEnum.GL_BLEND);
    gl.glRasterPos2d(x, y);
    gl.glPixelZoom(((float) width) / ((float) w), ((float) height) / ((float) h));
    gl.glDrawPixels(w, h, GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    gl.glPixelZoom(1f, 1f);
    gl.glDisable(GLEnum.GL_BLEND);
  }
  */
}
