/*
 * Soya3D
 * Copyright (C) 1999  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya2d;

import opale.soya.*;
import opale.soya.awt.*;
import gl4java.*;
import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * A texture that has transparency but no alpha blending (no semi-transparency).
 *
 * The mask should have only black and white pixels (no gray).
 *
 * @author Artiste on the Web
 */

public class TextureRGBM extends MaskedTexture {
  private static final long serialVersionUID = -8222370158800956774l; //2066205267965180913l;
  
  /**
   * Creates a new texture.
   */
  public TextureRGBM() {  }
  /**
   * Creates a new texture from the given image and mask.
   * @param image the image
   * @param mask  the mask
   */
  public TextureRGBM(java.awt.Image image, java.awt.Image mask) throws InterruptedException {
    setImage(image);
    setMask (mask );
  }
  /**
   * Creates a new texture from the given image and mask file name.
   * @param imageFileName the image file name
   * @param maskFileName  the mask file name
   */
  public TextureRGBM(String imageFileName, String maskFileName) throws InterruptedException {
    setImageFileName(imageFileName);
    setMaskFileName (maskFileName );
  }
  
  public Object clone() {
    try {
      if((imageFileName == null) || (imageFileName.equals(""))) return new TextureRGBA(getImage(), getMask());
      else return new TextureRGBA(imageFileName, maskFileName);
    }
    catch(Exception e) { e.printStackTrace(); return null; }
  }

  public boolean getUseAlpha() { return false; } // True or false ???
  public boolean isTransparent() { return true; } // True or false ???

  protected synchronized void build(GLFunc gl, GLUFunc glu) {
    super.build(gl, glu);
    gl.glPixelStorei(GLEnum.GL_UNPACK_ALIGNMENT, 1);
    if(Quality.useMipmaps)
      glu.gluBuild2DMipmaps(GLEnum.GL_TEXTURE_2D, GLEnum.GL_RGBA, getWidth(), getHeight(), GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    else
      gl.glTexImage2D(GLEnum.GL_TEXTURE_2D, 0, GLEnum.GL_RGBA, getWidth(), getHeight(), 0, GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());     // Optimizable : RGBA quicker than RGB ?

    Soya.checkError(gl, glu, "Building texture RGBM :");
  }

  public void makeCurrent(GLFunc gl, GLUFunc glu) {
    super.makeCurrent(gl, glu);
    gl.glAlphaFunc(GLEnum.GL_GREATER, 0.5f);
    gl.glEnable(GLEnum.GL_ALPHA_TEST);
  }
  public void unmakeCurrent(GLFunc gl, GLUFunc glu) { 
    super.unmakeCurrent(gl, glu);
    gl.glDisable(GLEnum.GL_ALPHA_TEST);
  }
  
  /*
  public void draw(GLFunc gl, GLUFunc glu, int x, int y) {
    gl.glEnable(GLEnum.GL_ALPHA_TEST);
    gl.glRasterPos2d(x, y);
    gl.glDrawPixels(getWidth(), getHeight(), GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    gl.glDisable(GLEnum.GL_ALPHA_TEST);
  }
  public void draw(GLFunc gl, GLUFunc glu, int x, int y, int width, int height) {
    int w = getWidth(), h = getHeight();
    gl.glEnable(GLEnum.GL_ALPHA_TEST);
    gl.glRasterPos2d(x, y);
    gl.glPixelZoom(((float) width) / ((float) w), ((float) height) / ((float) h));
    gl.glDrawPixels(w, h, GLEnum.GL_RGBA, GLEnum.GL_UNSIGNED_BYTE, getImageData());
    gl.glPixelZoom(1f, 1f);
    gl.glDisable(GLEnum.GL_ALPHA_TEST);
  }
  */
}
