/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.soya3d.animation.*;
import java.beans.*;

/**
 * Interface for any object that can be animated with soya.soya3d.animation .
 * 
 * @author Artiste on the web
 */

public interface Animable {
  /**
   * Gets the movement of this animable object.
   * Note that you should not use directly this method.
   * @see opale.soya.soya3d.World3D#setAnimation
   * @return the movement
   */
  public Movement getMovement();
  /**
   * Sets the movement of this animable object.
   * Note that you should not use directly this method.
   * @see opale.soya.soya3d.World3D#setAnimation
   * @param the new movement
   */
  public void setMovement(Movement m);

  /**
   * Gets the animation time of this animable object. You can change it in order to advance
   * (or go back) into the animation.
   * @return the animation time
   */
  public float getAnimationTime();
  /**
   * Sets the animation time of this animable object.
   * @param time the new animation time
   */
  public void setAnimationTime(float time);
}
