/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class Camera3DBeanInfo extends AbstractBeanInfo {
  public Camera3DBeanInfo() { 
    super(true, false, false); 

    PropertyDescriptor[] pd = new PropertyDescriptor[14];
    try {
      pd[ 0] = new PropertyDescriptor("drawablesCollectorClass", getBeanClass());
      pd[ 0].setHidden(true); // May not be hidden?
      pd[ 1] = new PropertyDescriptor("configurationChanger", getBeanClass(), "getConfigurationChanger", null);
      pd[ 1].setHidden(true);
      pd[ 2] = new PropertyDescriptor("front", getBeanClass());
      pd[ 3] = new PropertyDescriptor("back", getBeanClass());
      pd[ 4] = new PropertyDescriptor("FOV", getBeanClass());
      pd[ 5] = new PropertyDescriptor("ortho", getBeanClass());
      pd[ 6] = new PropertyDescriptor("renderingSurface", getBeanClass());
      pd[ 6].setHidden(true); // May not be hidden?
      pd[ 7] = new PropertyDescriptor("GLContext", getBeanClass());
      pd[ 7].setHidden(true);
      pd[ 8] = new PropertyDescriptor("position", getBeanClass(), "getPosition", null);
      pd[ 8].setHidden(true);
      pd[ 9] = new PropertyDescriptor("GLFunc", getBeanClass(), "getGLFunc", null);
      pd[ 9].setHidden(true);
      pd[10] = new PropertyDescriptor("GLUFunc", getBeanClass(), "getGLUFunc", null);
      pd[11].setHidden(true);
      pd[12] = new PropertyDescriptor("distanceTo", getBeanClass(), "getDistanceTo", null);
      pd[12].setHidden(true);
      pd[13] = new PropertyDescriptor("theoricalFPS", getBeanClass());
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);

  }
}
