/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;
import java.beans.*;

/**
 * @author Artiste on the Web
 */

public class CoordSystBeanInfo extends AbstractBeanInfo {
  public CoordSystBeanInfo() {
    super(true, false, false); 

    PropertyDescriptor[] pd = new PropertyDescriptor[6];
    try {
      pd[0] = new PropertyDescriptor("coordSyst", getBeanClass(), "getCoordSyst", null);
      pd[0].setHidden(true);
      pd[1] = new PropertyDescriptor("matrix", getBeanClass(), "getMatrix", null);
      pd[1].setHidden(true);
      pd[2] = new PropertyDescriptor("rootMatrix", getBeanClass(), "getRootMatrix", null);
      pd[2].setHidden(true);
      pd[3] = new PropertyDescriptor("invertedRootMatrix", getBeanClass(), "getInvertedRootMatrix", null);
      pd[3].setHidden(true);
      pd[4] = new PropertyDescriptor("leftHanded", getBeanClass(), "isLeftHanded", null);
      pd[4].setHidden(true);
      pd[5] = new PropertyDescriptor("rightHanded", getBeanClass(), "isRightHanded", null);
      pd[5].setHidden(true);
    }
    catch(Exception e) {
      System.out.println(getClass().getName() + " : error");
      e.printStackTrace();
    }
    addPropertyDescriptors(pd);
  }
}
