/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;

/**
 * Interface for all object that have dimensions.
 * 
 * @author Artiste on the Web
 */

public interface Dimension extends Bean {
  /**
   * Returns the coordinates system in witch the dimensions are defined.
   * @return the coordinates system.
   */
  public CoordSyst getCoordSyst();
  
  /**
   * Gets a dimension wrapper for this dimension. Suach a wrapper can be used for converting
   * dimensions from a coordinates system to another. The exact class of wrapper returned
   * depends on the dimension class.
   * This is not a property, and calling twice this method may not return the same wrapper.
   * @return a dimension wrapper
   */
  public DimensionWrapper wrapper();
  
  /**
   * Gets the width dimension.
   * @return the width
   */
  public float getWidth ();
  /**
   * Gets the height dimension.
   * @return the height
   */
  public float getHeight();
  /**
   * Gets the depth dimension.
   * @return the depth
   */
  public float getDepth ();
  /**
   * Sets the width dimension.
   * @param f the new width
   */
  public void setWidth (float f);
  /**
   * Sets the height dimension.
   * @param f the new height
   */
  public void setHeight(float f);
  /**
   * Sets the depth dimension.
   * @param f the new depth
   */
  public void setDepth (float f);
  
  /**
   * Sets the 3 dimensions.
   * @param w the new width
   * @param h the new height
   * @param d the new depth
   */
  public void setDims(float w, float h, float d);
  
  /**
   * Gets the zoom factors in the x dimension : the ratio between the size of this dimension
   * and its original size.
   * Returns 1f if non applicable. Default is 1f .
   * @return the factors
   */
  public float getXFactor();
  /**
   * Gets the zoom factors in the y dimension : the ratio between the size of this dimension
   * and its original size.
   * Returns 1f if non applicable. Default is 1f .
   * @return the factors
   */
  public float getYFactor();
  /**
   * Gets the zoom factors in the z dimension : the ratio between the size of this dimension
   * and its original size.
   * Returns 1f if non applicable. Default is 1f .
   * @return the factors
   */
  public float getZFactor();
  /**
   * Sets the zoom factors in the x dimension.
   * @param f the new factors
   */
  public void setXFactor(float f);
  /**
   * Sets the zoom factors in the z dimension.
   * @param f the new factors
   */
  public void setYFactor(float f);
  /**
   * Sets the zoom factors in the z dimension.
   * @param f the new factors
   */
  public void setZFactor(float f);
  
  /**
   * Scales this dimension.
   * @param factor the scale factor
   */
  public void scale(float factor);
  /**
   * Scales this dimension.
   * @param x the x scale factor
   * @param y the y scale factor
   * @param z the z scale factor
   */
  public void scale(float x, float y, float z);

  /**
   * Fires a resize property change event. Such an event is automatically fired when the
   * dimensions are changed; you shoud not have to use this method.
   * @see opale.soya.soya3d.event.ResizeEvent
   */
  public void fireResize();
  /**
   * Fires a resize property change event for the given property name. Such an event is
   * automatically fired when the dimensions are changed; you shoud not have to use this
   * method.
   * @see opale.soya.soya3d.event.ResizeEvent
   */
  public void fireResize(String propertyName);
  /**
   * Fires a resize property change event for the given property name, and the given old
   * and new values. Such an event is automatically fired when the dimensions are changed;
   * you shoud not have to use this method.
   * @see opale.soya.soya3d.event.ResizeEvent
   */
  public void fireResize(String propertyName, Object oldValue, Object newValue);
}
