/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.Matrix;
import opale.soya.soya2d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.util.*;
import java.io.*;

/**
 * A fragments collector is an object than collects the fragments, and then that draws
 * them. The fragments may be sorted or not, in order to perform some optimization.
 * 
 * A fragments collector must have a construct like this one :
 * public MyFragmentsCollector(Renderer r) {  }
 * 
 * @see opale.soya.soya3d.DrawablesCollectorFiller
 * 
 * @author Artiste on the Web
 */

public interface DrawablesCollector extends ConfigurationChanger, Serializable {
  /**
   * Gets the renderer.
   * @return the renderer.
   */
  public Renderer getRenderer();
  
  /**
   * Sets the GL and the GLU.
   * @param gl  the gl
   * @param glu the glu
   */
  void setGLandGLU(GLFunc gl, GLUFunc glu);
  
  /**
   * Resets the drawables collector for a new use.
   */
  public void reset(); // Before a new use.
  
  /**
   * Collects the given drawable.
   * @param f the drawable
   * @param mat the modelview matrix for the given drawable.
   */
  public void collect(Drawable f, float[] mat);
  /**
   * Collects the given drawables.
   * @param c a collection of drawables
   * @param mat the modelview matrix for the given drawables.
   */
  public void collectAll(java.util.Collection c, float[] mat);
  
  public void addSpecialEffect(SpecialEffect s);
  public void removeSpecialEffect(SpecialEffect s);
  
  /**
   * Draws the non-alpha-user drawables that has been collected.
   */
  public void draw();
  /**
   * Draws the alpha-user drawables that has been collected.
   */
  public void drawAlpha();

  /**
   * Draws the non-alpha-user drawables that has been collected, on the Z buffer only.
   * This is used by Z-prewriting.
   */
  public void drawZOnly();
  /**
   * Draws the alpha-user drawables that has been collected, on the Z buffer only.
   * This is used by Z-prewriting.
   */
  public void drawAlphaZOnly();
}
