/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.editor.*;
import java.util.Iterator;
import java.util.Enumeration;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;

/**
 * TreeNode used by WorldCustomizer.
 * 
 * @author Artiste on the Web
 */

/* public */ class ElementTreeNode extends DefaultMutableTreeNode implements CollectionListener {
  public ElementTreeNode()            { super(); }
  public ElementTreeNode(Element3D e) { this (); setElement(e); }
  public ElementTreeNode(World3DCustomizer c) {
    super();
    customizer = c;
  }
  public ElementTreeNode(World3DCustomizer customizer, JTree tree, DefaultTreeModel treeModel, Element3D e) {
    setTreeAndTreeModel(customizer, tree, treeModel);
    setElement(e);
  }
  
  private World3DCustomizer customizer;
  
  private JTree tree;
  public JTree getTree() { return tree; }
  private DefaultTreeModel treeModel;
  public DefaultTreeModel getTreeModel() { return treeModel; }
  public void setTreeAndTreeModel(World3DCustomizer c, JTree jtree, DefaultTreeModel treeMod) {
    customizer = c;
    tree = jtree;
    treeModel = treeMod;
    for(Enumeration i = children(); i.hasMoreElements(); )
      ((ElementTreeNode) i.nextElement()).setTreeAndTreeModel(c, tree, treeModel);
  }
  
  protected Element3D element;
  public Element3D getElement() { return element; } 
  public synchronized void setElement(Element3D e) {
    element = e;
    setUserObject(new Object() {
      public String toString() {
        if(element != null) return element.getDescription();
        return "(no element)";
      }
    });
    if(element instanceof World3D) { // Only world have children...
      World3D w = (World3D) element;
      setAllowsChildren(true);
      for(Iterator i = w.iterator(); i.hasNext(); ) {
        MutableTreeNode tn = customizer.getTreeNodeFor((Element3D) i.next());
        if(tn != null) add(tn);
        //add(new ElementTreeNode(tree, treeModel, (Element3D) i.next()));
      }
      w.addCollectionListener(this);
      if(tree != null) tree.collapsePath(new TreePath(getPath()));
    }
    else setAllowsChildren(false);
  }
  
  public synchronized void remove(Element3D e) {
    ElementTreeNode etn = getTreeNode(e);
    if(etn != null) treeModel.removeNodeFromParent(etn);
  }
  public synchronized ElementTreeNode getTreeNode(Element3D e) {
    for(Enumeration i = children(); i.hasMoreElements(); ) {
      ElementTreeNode etn = (ElementTreeNode) i.nextElement();
      if(etn.getElement() == e) return etn;
    }
    return null;
  }
  
  private java.awt.Frame getFrame() {
    Component c = tree;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
  
  public void menuActionEdit() {
    customizer.edit(element);
    /*
    try { Editor.edit(element, false); } // No saving : sub-edition.
    catch(Exception e) { System.out.println("Can't edit!"); e.printStackTrace(); }
    */
  }
  public void menuActionEditInNewWindow() {
    try { Editor.edit(element, false); } // No saving : sub-edition.
    catch(Exception e) { System.out.println("Can't edit!"); e.printStackTrace(); }
  }
  public void menuActionAdd(Element3D e) {
    if(element instanceof World3D) ((World3D) element).add(e);
  }
  public void menuActionDelete() {
    if(element.getParent() == null) return;
    if(YesNoDialog.question(getFrame(), "Confirmation", "Really delete " + element.getName() + " ?")) {
      element.remove();
    }
  }
  public void menuActionResetPosition() {
    if(element instanceof Position) ((Position) element).move(0f, 0f, 0f);
  }
  public void menuActionResetOrientation() {
    if(element instanceof Orientation) ((Orientation) element).resetOrientation();
  }
  public void menuActionChooseTarget() {
    if(element instanceof Orientation) {
      final Orientation o = (Orientation) element;
      final Position p = o.target();
      p.setCoordSyst(element.getParent());
      try {
        Editor.edit(p).addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {
            o.lookAt(p);
          }
        });
      }
      catch(Exception e) { System.out.println("Can't edit target!"); e.printStackTrace(); }
    }
  }
  public void menuActionConvertToShape() {
    if(element instanceof World3D) {
      try { Editor.edit(((World3D) element).toShape()); }
      catch(Exception e) { System.out.println("Can't convert to shape!"); e.printStackTrace(); }
    }
  }
  public void menuActionDump() { System.out.println(element); }
  public void menuActionDumpMatrix() {
    if(element instanceof GraphicalElement3D) {
      System.out.println(Matrix.matrixToString(((GraphicalElement3D) element).getMatrix()));
    }
  }
  
  public void added  (AddEvent    e) {
    //ElementTreeNode etn = new ElementTreeNode(customizer, tree, treeModel, (Element3D) e.getElement());
    ElementTreeNode etn = (ElementTreeNode) customizer.getTreeNodeFor((Element3D) e.getElement());
    if(etn != null) {
      treeModel.insertNodeInto(etn, this, getChildCount());
      tree.setSelectionPath(new TreePath(etn.getPath()));
    }
  }
  public void removed(RemoveEvent e) {
    remove((Element3D) e.getElement());
  }
}
