/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

/**
 * Interface for complex raypicking.
 * 
 * @author Artiste on the Web
 */

public interface RaypickingComplex extends Raypicking {
  /**
   * Returns all the intersection between this object and the given ray.
   * Only the nearest intersection to origin is returned.
   * @param origin the origin of the ray
   * @param direction the direction of the ray
   * @param sens a SENS_* constant that indicates if the ray is a straight or a half line
   * @param intersection a INTERSECTION_* constant that indicates if the method takes in
   * account intersection with backfaced face
   * @param maxHits the maximum number of hits
   * @return a RaypickingComplexResult object that contains all the intersection
   */
  public RaypickingComplexResult raypickComplex(Position origin, Vector direction, int sens, int intersection, int maxHits);
  
  /**
   * Class for the result of a complex raypicking.
   */
  public static class RaypickingComplexResult {
    /**
     * Creates a new RaypickingComplexResult.
     */
    public RaypickingComplexResult() {  }
    /**
     * Creates a new RaypickingComplexResult.
     * @param o the origin of the ray
     * @param v the direction of the ray
     * @param s a SENS_* constant that indicates if the ray is a straight or a half line
     * @param i a INTERSECTION_* constant that indicates if the method takes in
     * account intersection with backfaced face
     * @param max the maximum number of hits
     */
    public RaypickingComplexResult(Position o, Vector v, int s, int i, int max) {
      origin = o;
      direction = v;
      sens = s;
      intersection = i;
      maxHits = max;
    }
    
    /** the origin of the ray. */
    public Position origin;
    /** the direction of the ray. */
    public Vector direction;
    /** a SENS_* constant that indicates if the ray is a straight or a half line. */
    public int sens;
    /**
     * a INTERSECTION_* constant that indicates if the method takes in account intersection
     * with backfaced face
     */
    public int intersection;
    /** the maximum number of hits. */
    public int maxHits;
    
    /** The collection of hits. */
    public java.util.Collection hits = (java.util.Collection) new java.util.Vector();
  }
  /**
   * Class that represent a hit (= an intersection).
   */
  public static class Hit {
    /**
     * Creates a new hit.
     */
    public Hit() {  }
    /**
     * Creates a new hit.
     * @param e the hit element
     * @param w the position where the hit occured.
     */
    public Hit(Element3D e, Position w) {
      element = e;
      where = w;
    }
    /** The hit element. */
    public Element3D element;
    /** The position where the hit occured. */
    public Position where;
  }
}
