/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.awt.*;
import gl4java.*;

/**
 * A Renderer is an object that can render the 3D on a RenderingSurface.
 * 
 * @see opale.soya.soya3d.Camera3D
 * 
 * @author Artiste on the Web
 */
public interface Renderer {
  /**
   * Gets the rendering surface on which this renderer draws.
   * @return the rendering surface
   */
  public RenderingSurface getRenderingSurface();
  /**
   * Sets the rendering surface on which this renderer draws.
   * @param rs the rendering surface
   */
  public void setRenderingSurface(RenderingSurface rs);
  /**
   * Gets the GL Context of this renderer.
   * @return the GL context
   */
  public GLContext getGLContext();
  /**
   * Gets the GL of this renderer.
   * @return the GL
   */
  public GLFunc  getGLFunc ();
  /**
   * Gets the GLU of this renderer.
   * @return the GLU
   */
  public GLUFunc getGLUFunc();
  
  /**
   * Gets the position of this renderer.
   * @return the position
   */
  public Position getPosition();
  /**
   * Gets the distance between the renderer and the current position. Can be use only when
   * collecting fragments.
   * @return the position
   */
  //public float getDistanceTo();
  /**
   * Gets a new GL light ID.
   * @param dynamic true for pure-dynamic light (doesn't light static-lit object)
   * @return a GL light ID or 0 if no more IDs are avalaible.
   */
  public int newLightID(boolean dynamic);
  /**
   * Sets the pure-dynamic lights visible or not. This method is used when drawing static
   * lit fragments.
   * @param true for visible (=enabled), false to disable
   */
  public void setDynamicLightsVisible(boolean b);
  
  /**
   * Renders. Don't call this method directly, use opale.soya.awt.RenderingSurface.render().
   */
  public void render();
  
  /**
   * Gets the configuration changer of this renderer. The configuration changer is used
   * while rendering.
   * @see opale.soya.soya3d.ConfigurationChanger
   * @return the configuration changer
   */
  public ConfigurationChanger getConfigurationChanger();
  
  public float[] modelMatrix();
  
  // FPS :
  /**
   * Gets the theorical FPS. the speed of the scene will be the same as if it was rendered
   * at this FPS value.
   * Default is 20 FPS
   * @return the theorical FPS
   */
  public float getTheoricalFPS();
  /**
   * Sets the theorical FPS.
   * @param f the new theorical FPS
   */
  public void setTheoricalFPS(float f);
  /**
   * Gets the current FPS.
   * @return the fps
   */
  public float fps();
  /**
   * Gets the current FPS factor : the ratio between the theorical FPS and the real one.
   * @return the fps factor
   */
  public float fpsFactor();
}
