/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.util.*;

/**
 * A rotable is an object that can rotate.
 * 
 * @author Atrtiste on the Web
 */

public interface Rotable {
  /**
   * Returns the coordinates system in witch this rotable object is defined.
   * @return the coordinates system.
   */
  public CoordSyst getCoordSyst();
  
  /**
   * Rotates this object around the given axis, defined by the given point and vector.
   * @param origin the origin of the axis of the rotation
   * @param vector the direction of the axis of the rotation
   * @param angle the angle of the rotation
   */
  public void rotate(Position origin, Vector vector, float angle);
  /**
   * Rotates this object around the given axis, defined by 2 points.
   * @param p1 a point of the axis of the rotation
   * @param p2 another point of the axis of the rotation
   * @param angle the angle of the rotation
   */
  public void rotate(Position p1, Position p2, float angle);
}
