/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

/**
 * Interface for any object that can be transformed by a matrix .
 * 
 * @author Artiste on the web
 */

public interface Transformable {
  /**
   * Transforms this object.
   * @param m the matrix (a float[16]) that defines the transformation
   */
  public void transform(float[] m);
  
  /**
   * Moves this transformable by the given vector. For point, it's a translation; for vector
   * it's means vectorial addition.
   * If required, a frame coordinates convertion is performed.
   * @param v the vector
   */
  public void addVector(Vector v);
  /**
   * Moves this transformable by the given vector. For point, it's a translation; for vector
   * it's means vectorial addition.
   * @param vx the vector x coordinate
   * @param vy the vector y coordinate
   * @param vz the vector z coordinate
   */
  public void addVector(float vx, float vy, float vz);
  /**
   * Uniformaly scales this transformable.
   * @param f the scale factor
   */
  public void scale(float f);
  /**
   * Scales this transformable.
   * @param fx the x scale factor
   * @param fy the y scale factor
   * @param fz the z scale factor
   */
  public void scale(float fx, float fy, float fz);
}
