/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d;

import opale.soya.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.editor.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
	
public class World3DCustomizer extends Panel implements Customizer {
  public World3DCustomizer() { 
    super(); 
    setLayout(new BorderLayout());
    
    Button b = new Button("Soya GUI editor...");
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { GUIEdit(); }
    });
    add(b, BorderLayout.SOUTH);
    
    popup = buildPopupMenu();
  }
  
  protected void GUIEdit() {
    if(world.getParent() == null) WorldGUIEditor.edit(world, tree, treeModel);
    else System.out.println("Cannot GUI edit. This world has already a parent !!!");
  }
  
  public MutableTreeNode getTreeNodeFor(Element3D e) {
    return new ElementTreeNode(this, tree, treeModel, e);
  }
  public void edit(Object bean) {
    Object o = getFrame();
    Class[] paramsClazz = { java.lang.Object.class };
    Object[] params = { bean };
    try {
      Method edit = o.getClass().getMethod("edit", paramsClazz);
      edit.invoke(o, params);
    }
    catch(Exception e) {
      e.printStackTrace();
      System.out.println(o.getClass().getName());
      try { Editor.edit(bean, false); } // No saving : sub-edition.
      catch(Exception e2) { System.out.println("Can't edit!"); e2.printStackTrace(); }
    }
  }
  
  protected JTree tree;
  protected DefaultTreeModel treeModel;
  protected ElementTreeNode root;
  protected World3D world;
  protected ScrollPane scrollPane;
  public void setObject(Object o) {
    world = (World3D) o;
    
    scrollPane = new ScrollPane(ScrollPane.SCROLLBARS_ALWAYS);
    add(scrollPane);
    
    root      = new ElementTreeNode (this     );
    treeModel = new DefaultTreeModel(root     );
    tree      = new JTree           (treeModel);
    root.setTreeAndTreeModel(this, tree, treeModel);
    root.setElement  (world    );
    scrollPane.add(tree);
    tree.addMouseListener(mouseListener);
    tree.expandRow(0);
    tree.add(popup);
    tree.setScrollsOnExpand(true);
    tree.setAutoscrolls(true);
    tree.addTreeExpansionListener(new TreeExpansionListener() {
      public void treeCollapsed(TreeExpansionEvent e) { refresh(); }
      public void treeExpanded (TreeExpansionEvent e) { refresh(); }
    });
  }
  
  protected void refresh() {
    scrollPane.doLayout();
    java.awt.Dimension d = tree.getPreferredSize();
    int w = 0, h = 0;
    if(d.getWidth () < scrollPane.getWidth ()) w = scrollPane.getWidth (); else w = (int) d.getWidth ();
    if(d.getHeight() < scrollPane.getHeight()) h = scrollPane.getHeight(); else h = (int) d.getHeight();
    tree.setSize(w, h);
  }
  
  public java.awt.Dimension getPreferredSize() { return new java.awt.Dimension(150, 250); }

  public void addPropertyChangeListener(PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }
  
  private MouseListener mouseListener = new MouseAdapter() {
    public void mouseClicked(MouseEvent e) {
      int modifiers = e.getModifiers();
      int x = e.getX(), y = e.getY();
      TreePath path = tree.getClosestPathForLocation(x, y);
      if((modifiers & MouseEvent.BUTTON3_MASK) == MouseEvent.BUTTON3_MASK) {
        tree.setSelectionPath(path);
        Object o = path.getLastPathComponent();
        if(o instanceof ElementTreeNode) showPopupMenuFor(((ElementTreeNode) o).getElement(), x, y);
      }
      if((modifiers & MouseEvent.BUTTON2_MASK) == MouseEvent.BUTTON2_MASK) {
        ((ElementTreeNode) path.getLastPathComponent()).menuActionEdit();
        tree.setSelectionPath(path);
      }
    }
  };

  protected ElementTreeNode getSelectedTreeNode() { return (ElementTreeNode) tree.getSelectionPath().getLastPathComponent(); }

  private PopupMenu popup;
  private Menu menuAdd;
  private MenuItem menuConvertToShape;
  protected PopupMenu buildPopupMenu() {
    PopupMenu popup = new PopupMenu();
    MenuItem menu1= new MenuItem("Edit...");
    menu1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionEdit(); }
    });
    popup.add(menu1);
    MenuItem menu1bis = new MenuItem("Edit in new window...");
    menu1bis.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionEditInNewWindow(); }
    });
    popup.add(menu1bis);
    MenuItem menu2 = new MenuItem("Delete");
    menu2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionDelete(); refresh(); }
    });
    popup.add(menu2);
    MenuItem menu3 = new MenuItem("Reset position");
    menu3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionResetPosition(); }
    });
    popup.add(menu3);
    MenuItem menu4 = new MenuItem("Reset orientation");
    menu4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionResetOrientation(); }
    });
    popup.add(menu4);
    MenuItem menu7 = new MenuItem("Choose target...");
    menu7.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionChooseTarget(); }
    });
    popup.add(menu7);
    MenuItem menu5 = new MenuItem("Dump...");
    menu5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionDump(); }
    });
    popup.add(menu5);
    MenuItem menu6 = new MenuItem("Dump matrix...");
    menu6.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionDumpMatrix(); }
    });
    popup.add(menu6);
    
    menuAdd = buildAddMenu();
    popup.add(menuAdd);
    
    menuConvertToShape = new MenuItem("Convert to shape...");
    menuConvertToShape.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionConvertToShape(); }
    });
    popup.add(menuConvertToShape);
    
    return popup;
  }
  protected Menu buildAddMenu() {
    Menu menuAdd = new Menu("Add");
    MenuItem menuAdd1 = new MenuItem("Camera");
    menuAdd1.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionAdd(new Camera3D()); refresh(); }
    });
    menuAdd.add(menuAdd1);
    MenuItem menuAdd2 = new MenuItem("Light");
    menuAdd2.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionAdd(new Light3D()); refresh(); }
    });
    menuAdd.add(menuAdd2);
    MenuItem menuAdd3 = new MenuItem("Volume");
    menuAdd3.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionAdd(new Volume3D()); refresh(); }
    });
    menuAdd.add(menuAdd3);
    MenuItem menuAdd4 = new MenuItem("World");
    menuAdd4.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionAdd(new World3D()); refresh(); }
    });
    menuAdd.add(menuAdd4);
    MenuItem menuAdd5 = new MenuItem("Environment");
    menuAdd5.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { getSelectedTreeNode().menuActionAdd(new Environment3D()); refresh(); }
    });
    menuAdd.add(menuAdd5);
    MenuItem menuAdd6 = new MenuItem("Other...");
    menuAdd6.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        try { getSelectedTreeNode().menuActionAdd((Element3D) ClassChooser.question(getFrame()).newInstance()); refresh(); }
        catch(Exception ex) { System.out.println("Can't create an instance of this class!"); ex.printStackTrace(); }
      }
    });
    menuAdd.add(menuAdd6);
    return menuAdd;
  }
  public void showPopupMenuFor(Element3D e, int x, int y) {
    if(e instanceof World3D) {
      menuAdd           .setEnabled(true );
      menuConvertToShape.setEnabled(true );
    }
    else {
      menuAdd           .setEnabled(false);
      menuConvertToShape.setEnabled(false);
    }
    popup.show(tree, x, y);
  }
  
  protected java.awt.Frame getFrame() {
    Component c = this;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
}
