/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.awt.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.animation.*;
import opale.soya.editor.*;
import java.beans.*;
import java.util.Iterator;
import java.awt.*;
import java.awt.event.*;

public class AnimationCustomizer extends Panel implements AdjustmentListener, PropertyChangeListener, Customizer {
  public AnimationCustomizer(Animation animation, World3D world) {
    super(new BorderLayout());
    
    a = animation;
    a.addPropertyChangeListener(this);
    w = world;
    
    list = new java.awt.List();
    float[] times = a.times();
    int nb = times.length;
    for(int i = 0; i < nb; i++) list.add(Float.toString(times[i]));
    list.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String time = list.getSelectedItem();
        if(time != null) {
          w.setAnimation(null);
          w.setAnimation(a);
          w.setAnimationTime(Float.parseFloat(time));
          //w.setAnimation(null);
        }
      }
    });
    add(list, BorderLayout.CENTER);
    
    p = new Panel(new GridLayout(7, 1));
    final TextField t = new TextField("0");
    add(p, BorderLayout.SOUTH);
    p2 = new Panel(new GridLayout(1, 2));
    Button add = new Button("Add state at :");
    add.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        //a.addCurrentState(Float.parseFloat(TextChooser.question(getFrame(), "Add to time ?", "")), w);
        float f = Float.parseFloat(t.getText());
        a.addCurrentState(f, w);
        t.setText(Float.toString(f + 1f));
      }
    });
    p2.add(add);
    p2.add(t);
    p.add(p2);
    
    Button move = new Button("Move state...");
    move.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String time = list.getSelectedItem();
        if(time == null) return;
        float newTime = Float.parseFloat(TextChooser.question(getFrame(), "Enter new time :"));
        a.changeTime(Float.parseFloat(time), newTime);
      }
    });
    p.add(move);
    
    Button delete = new Button("Delete state");
    delete.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        String time = list.getSelectedItem();
        if(time != null) a.removeState(Float.parseFloat(time));
      }
    });
    p.add(delete);
    
    Button scale = new Button("Scale...");
    scale.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        float f = Float.parseFloat(TextChooser.question(getFrame(), "Enter scale factor :"));
        a.scale(f);
      }
    });
    p.add(scale);
    
    Button dump = new Button("Dump...");
    dump.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { System.out.println(a); }
    });
    p.add(dump);
    
    bar = new Scrollbar(Scrollbar.HORIZONTAL, 0, 100, (int) (a.getFirstAvalaibleTime() * 100f), (int) (a.getLastAvalaibleTime() * 100f) + 100);
    bar.addAdjustmentListener(this);
    p.add(bar);
    
    play = new Checkbox("Play");
    play.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if(play.getState()) {
          playThread = new PlayThread();
          playThread.start();
        }
      }
    });
    p.add(play);
    
    p.doLayout();
  }
  public void finalize() {
    a.removePropertyChangeListener(this);
  }
  
  private Panel p, p2;
  public void doLayout() {
    super.doLayout();
    p .doLayout();
    p2.doLayout();
  }
  
  private Animation a;
  public void setObject(Object o) { a = (Animation) o; }
  private World3D w;
  
  public java.awt.Dimension getPreferredSize() { return new java.awt.Dimension(100, 250); }

  public void addPropertyChangeListener(PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }
  
  java.awt.List list;
  
  Scrollbar bar;
  public void adjustmentValueChanged(AdjustmentEvent e) {
    //if(play.getState()) return;
    w.setAnimation(null);
    w.setAnimation(a);
    w.setAnimationTime(((float) bar.getValue()) / 100f);
    //w.setAnimation(null);
  }
  private void redefineScrollbar() {
    int value = bar.getValue();
    int start = (int) (a.getFirstAvalaibleTime() * 100f), end = (int) (a.getLastAvalaibleTime() *100f);
    if(value < start) value = start;
    if(value < end  ) value = end  ;
    bar.setValues(value, 100, start, end + 100);
  }
  
  private Checkbox play;
  private class PlayThread extends Thread {
    private long[] lastTimes;
    public void run() {
      float i;
      if(lastTimes == null) {
        lastTimes = new long[10];
        lastTimes[9] = System.currentTimeMillis();
        for(int j = 8; j >= 0; j--) {
          lastTimes[j] = lastTimes[j + 1] - 30l;
        }
      }
      w.lock();
      for(i = a.getFirstAvalaibleTime(); i < a.getLastAvalaibleTime(); ) {
        if(!play.getState()) return;
        
        int max = lastTimes.length - 1;
        System.arraycopy(lastTimes, 1, lastTimes, 0, max);
        lastTimes[max] = System.currentTimeMillis();
        float fps = 1000f * ((float) lastTimes.length) / ((float) (lastTimes[max] - lastTimes[0]));
        float factor = 30f / fps;
        i = i + factor * .2f;
        
        w.setAnimation(null);
        w.setAnimation(a);
        w.setAnimationTime(i);
        //w.setAnimation(null);
        
        for(Iterator j = w.getRootParent().cameras(); j.hasNext(); ) {
          RenderingSurface r = ((Camera3D) j.next()).getRenderingSurface();
          if(r != null) r.render();
        }
      }
      w.unlock();
      if(a.isCyclic()) run();
      else play.setState(false);
    }
  };
  private Thread playThread;
  
	public synchronized void propertyChange(PropertyChangeEvent e) {
    if(e.getPropertyName() == "movements") {
      int index = list.getSelectedIndex();
      list.removeAll();
      float[] times = a.times();
      int nb = times.length;
      for(int i = 0; i < nb; i++) list.add(Float.toString(times[i]));
      list.select(index);
      redefineScrollbar();
    }
    if(e.getPropertyName() == "cyclicLap") redefineScrollbar();
  }
  
  private java.awt.Frame getFrame() {
    Component c = this;
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
}
