/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import java.lang.ref.*;
import java.io.*;
import java.beans.*;
import java.util.Iterator;

public class Animations extends Bag implements Bean, StoredInPathObject {
  public Animations() {  }
  
  public Object clone() {
    Animations as = new Animations();
    as.name = name;
    for(Iterator i = iterator(); i.hasNext(); ) as.add((Animation) ((Animation) i.next()).clone());
    return as;
  }
  
  // stuff for serialization : allows other classes to serialize Animations object.
  public void write(ObjectOutputStream s) throws IOException {
    if(hasName()) {
      s.writeInt(OBJECT_SAVED_IN_PATH);
      s.writeUTF(name);
    }
    else {
      s.writeInt(OBJECT_SAVED_HERE);
      s.writeObject(this);
    }
  }
  public static void write(ObjectOutputStream s, Animations as) throws IOException {
    if(as == null) s.writeInt(NO_OBJECT_SAVED);
    else as.write(s);
  }
  public static Animations read(ObjectInputStream s) throws IOException, ClassNotFoundException {
    switch(s.readInt()) {
    case NO_OBJECT_SAVED     : return null;
    case OBJECT_SAVED_IN_PATH: return get(s.readUTF());
    case OBJECT_SAVED_HERE   : return (Animations) s.readObject();
    }
    return null;
  }

  private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException { // Initialization.
    s.defaultReadObject();
    softReferenceToThis = new SoftReference(this);
    if(hasName()) animationss.add(softReferenceToThis);
  }

  public static String path;
  /**
   * Set the animations path.
   * @see opale.soya.soya3d.animation.Animations#path
   * @param p the new path
   */
  public static void setPath(String p) {
    if(p.endsWith("/")) path = p;
    else path = p + "/";
  }
  
  public synchronized void save() throws java.io.IOException {
    save(path + name + ".animations");
  }
  public synchronized void save(String fileName) throws java.io.IOException {
    try {
      ObjectOutputStream o = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
      o.writeObject(this);
      o.flush();
      o.close();
    }
    catch(Exception e) {
      throw (java.io.IOException) e;
    }
  }
  public static void save(Animations m) throws java.io.IOException { m.save(); }
  public static void save(Animations m, String fileName) throws java.io.IOException { m.save(fileName); }
  public static Animations load(String fileName) throws java.io.IOException, java.lang.ClassNotFoundException {
    Animations m;
    ObjectInputStream i = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
    m = (Animations) i.readObject();
    i.close();
    return m;
  }
  private static final java.util.Set animationss = new java.util.HashSet();
  public static Animations get(String name) throws java.io.IOException, java.lang.ClassNotFoundException {
    Animations m;
    for(Iterator i = animationss.iterator(); i.hasNext(); ) {
      m = (Animations) ((SoftReference) i.next()).get();
      if(m == null) i.remove();
      else {
        if(m.name.equals(name)) return m;
      }
    }
    return load(path + name + ".animations");
  }
  
  public synchronized boolean add(Animation a) { return super.add(a); }
  public boolean add(Object o) { throw new UnsupportedOperationException("Only animation can be added or removed to animations."); }
  public synchronized boolean remove(Animation a) { return super.remove(a); }
  public synchronized boolean remove(String name) {
    Animation a;
    for(Iterator i = iterator(); i.hasNext(); ) {
      a = (Animation) i.next();
      if(name.equals(a.getName())) {
        i.remove();
        fireRemove(a);
        return true;
      }
    }
    return false;
  }
  public boolean remove(Object o) { throw new UnsupportedOperationException("Only animation can be added or removed to animations."); }
  public synchronized Animation animation(String name) {
    Animation a;
    for(Iterator i = iterator(); i.hasNext(); ) {
      a = (Animation) i.next();
      if(name.equals(a.getName())) return a;
    }
    return null;
  }
  
  private String name;
  public String getName() { return name; }
  public boolean hasName() { return ((name != null) && (!"".equals(name))); }
  public synchronized void setName(String newName) {
    String oldName = name;
    boolean oldHasName = hasName();
    name = newName;
    if(hasName() && !oldHasName) animationss.add(softReferenceToThis);
    else {
      if(!hasName() && oldHasName) animationss.remove(softReferenceToThis);
    }
    firePropertyChange("name", oldName, name);
  }
  private transient SoftReference softReferenceToThis = new SoftReference(this);


  // Event :
  protected transient java.util.Collection changeListeners;
  public java.util.Collection propertyChangeListeners() { return changeListeners; }
  public void addPropertyChangeListener   (PropertyChangeListener l) {
    if(changeListeners == null) changeListeners = new java.util.Vector();
    synchronized(changeListeners) { changeListeners.add(l); }
  }
  public void removePropertyChangeListener(PropertyChangeListener l) {
    if(changeListeners != null) {
      synchronized(changeListeners) { changeListeners.remove(l); }
    }
  }
  protected boolean isWorthFiringEvent() {
    return (changeListeners != null) && (!changeListeners.isEmpty());
  }
  public void firePropertyChange() {
    synchronized(changeListeners) {
      if(isWorthFiringEvent()) firePropertyChange(new PropertyChangeEvent(this, "", null, null));
    }
  }
  public void firePropertyChange(String propertyName) {
    synchronized(changeListeners) {
      if(isWorthFiringEvent()) firePropertyChange(new PropertyChangeEvent(this, propertyName, null, null));
    }
  }
  public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    if(oldValue != null && oldValue.equals(newValue)) return;
    synchronized(changeListeners) {
      if(isWorthFiringEvent()) firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
    }
  }
  protected void firePropertyChange(PropertyChangeEvent e) {
    int size;
    Object[] ls;
    synchronized (changeListeners) {
      size = changeListeners.size();
      ls = changeListeners.toArray();
    }
    for (int i = 0; i < size; i++) ((PropertyChangeListener) ls[i]).propertyChange(e);
  }
  
  protected transient java.util.Collection subListeners;
  public synchronized  void addSubPropertyChangeListener(PropertyChangeListener l) {
    if(subListeners == null) {
      subListeners = new java.util.Vector();
      addCollectionListener(new CollectionListener() {
        public void added(AddEvent e) {
          if(subListeners != null) {
            Animation a = (Animation) e.getElement();
            for(Iterator i = subListeners.iterator(); i.hasNext(); ) a.addPropertyChangeListener((PropertyChangeListener) i.next());
          }
        }
        public void removed(RemoveEvent e) {
          if(subListeners != null) {
            Animation a = (Animation) e.getElement();
            for(Iterator i = subListeners.iterator(); i.hasNext(); ) a.removePropertyChangeListener((PropertyChangeListener) i.next());
          }
        }
      });
    }
    subListeners.add(l);
    for(Iterator i = iterator(); i.hasNext(); ) ((Animation) i.next()).addPropertyChangeListener(l);
  }
  public synchronized void removeSubPropertyChangeListener(PropertyChangeListener l) {
    if(subListeners != null) {
      subListeners.remove(l);
      for(Iterator i = iterator(); i.hasNext(); ) ((Animation) i.next()).removePropertyChangeListener(l);
    }
  }
  
  /*
  private collectionListener = new CollectionListener() {
    public void added(AddEvent e) {
      if(subListeners != null) {
        Animation a = (Animation) e.getElement();
        for(Iterator i = subListeners.iterator(); i.hasNext(); ) a.addPropertyChangeListener((PropertyChangeListener) i.next());
      }
    }
    public void removed(RemoveEvent e) {
      if(subListeners != null) {
        Animation a = (Animation) e.getElement();
        for(Iterator i = subListeners.iterator(); i.hasNext(); ) a.removePropertyChangeListener((PropertyChangeListener) i.next());
      }
    }
  }
  */
}
