/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.animation;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.editor.*;
import opale.soya.soya2d.*;
import java.io.*;
import java.beans.*;
import java.awt.*;

/**
 * @author Artiste on the Web
 */

public class AnimationsEditor extends StoredInPathObjectEditor {
  // Overrides :
  protected StoredInPathObject getNew  () { return new Animations(); }
  protected StoredInPathObject getNamed(String name) {
    try { return Animations.get(name); }
    catch(Exception e) {
      System.out.println("Can't find animations : " + name);
      e.printStackTrace();
    }
    return getNull();
  }
  
  private String[] tags = computeTags(Animations.path, ".animations");
  public String[] getTags() { return tags; }
  protected StoredInPathObject list() {
    try {
      String name = StoredInPathObjectChooser.question(getFrame(), Animations.path, "animations", true);
      if(name == null) return null;
      return Animations.get(name); 
    }
    catch(Exception e) { System.out.println("can't find or list animations!"); e.printStackTrace(); }
    return null;
  }
  private java.awt.Frame getFrame() {
    java.awt.Component c = getCustomEditor();
    while(true) {
      c = c.getParent();
      if(c instanceof java.awt.Frame) return (java.awt.Frame) c;
    }
  }
  
  private Component customEditor;
  public Component getCustomEditor() {
    if(customEditor == null) customEditor = new PropertySelector(this);
    return customEditor;
  }
}
