/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.event;

import java.beans.*;

/**
 * A property change event that is also a move-event, a rotate-event and a resize-event. Such
 * an event is fired when the source animationState has changed, for example : its position,
 * orientation and dimensions have changed (or may have changed).
 * 
 * See soya.soya3D.event.MoveEvent, soya.soya3D.event.RotateEvent and 
 * soya.soya3D.event.ResizeEvent .
 * 
 * @author Artiste on the Web
 */

public class PropertyChangeAnimationEvent extends PropertyChangeEvent implements MoveEvent, OrientateEvent, ResizeEvent {
  public PropertyChangeAnimationEvent(Object source) {
    super(source, "animationTime", null, null);
  }
  public PropertyChangeAnimationEvent(Object source, String propertyname) {
    super(source, propertyname, null, null);
  }
  public PropertyChangeAnimationEvent(Object source, String propertyname, Object oldValue, Object newValue) {
    super(source, propertyname, oldValue, newValue);
  }
}
