/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A sprite.
 *
 * @author Artiste on the Web
 */

public class Sprite3D extends FragmentElement3D implements Colored {
  /**
   * Create a sprite.
   */
  public Sprite3D() { super(); }
  /**
   * Create a sprite with the given material.
   */
  public Sprite3D(Material m) { super(); setMaterial(m); }
  /**
   * Create a sprite with the given name.
   * @param name the name
   */
  public Sprite3D(String name) { super(name); }
  
  /**
   * Clones this sprite.
   * @return the clone
   */
  public Object clone() {
    Sprite3D o = (Sprite3D) super.clone();
    o.material = material;
    return o;
  }
  
  // Overrides : hackish :
  public void fillCollector(DrawablesCollector f, Renderer r, float[] mat) { // Optimizable
    if(visible) {
      if(leftHanded) f.invertConfiguration();
      mat = Matrix.matrixMultiply(mat, m);
      mat[ 0] = 1;
      mat[ 1] = 0;
      mat[ 2] = 0;
      
      mat[ 4] = 0;
      mat[ 5] = 1;
      mat[ 6] = 0;
      
      mat[ 8] = 0;
      mat[ 9] = 0;
      mat[10] = 1;
      f.collect(this, mat);
      if(leftHanded) f.invertConfiguration();
    }
  }
  
  public void draw(Renderer r, GLFunc gl, GLUFunc glu) { // Draw the sphere with the glu function.
    gl.glDisable(GLEnum.GL_CULL_FACE);
    gl.glEnable (GLEnum.GL_COLOR_MATERIAL);
    gl.glColor4fv(color);
    
    gl.glBegin(GLEnum.GL_QUADS);
    gl.glTexCoord2f(0f, 0f); gl.glVertex3f(x1, y1, 0f);
    gl.glTexCoord2f(1f, 0f); gl.glVertex3f(x2, y1, 0f);
    gl.glTexCoord2f(1f, 1f); gl.glVertex3f(x2, y2, 0f);
    gl.glTexCoord2f(0f, 1f); gl.glVertex3f(x1, y2, 0f);
    gl.glEnd();
    
    gl.glEnable(GLEnum.GL_CULL_FACE);
    gl.glDisable (GLEnum.GL_COLOR_MATERIAL);
    material.makeColorCurrent(gl, glu);
  }
  
  // A few properties.
  protected float x1 = -.5f, y1 = -.5f, x2 = .5f, y2 = .5f;
  public float getX1() { return x1; }
  public float getY1() { return y1; }
  public float getX2() { return x2; }
  public float getY2() { return y2; }
  public void setX1(float f) {
    x1 = f;
    firePropertyChange("x1");
  }
  public void setY1(float f) {
    y1 = f;
    firePropertyChange("y1");
  }
  public void setX2(float f) {
    x2 = f;
    firePropertyChange("x2");
  }
  public void setY2(float f) {
    y2 = f;
    firePropertyChange("y2");
  }
  
  protected final float[] color = (float[]) Material.WHITE_COLOR.clone();
  public float[] getColor() {	return color; }
  public void setColor(float red, float green, float blue) { setColor(red, green, blue, 1f); }
  public void setColor(float red, float green, float blue, float alpha) {
    color[0] = red;
    color[1] = green;
    color[2] = blue;
    color[3] = alpha;
    firePropertyChange("color");
  }
  public void setColor(float[] c) {
    System.arraycopy(c, 0, color, 0, 4);
    firePropertyChange("color");
  }
  public boolean getUseColor() { return true; }
  public float getRed  () { return color[0]; }
  public float getGreen() { return color[1]; }
  public float getBlue () { return color[2]; }
  public float getAlpha() { return color[3]; }
  public void setRed  (float f) {
    color[0] = f;
    firePropertyChange("color");
  }
  public void setGreen(float f) {
    color[1] = f;
    firePropertyChange("color");
  }
  public void setBlue (float f) {
    color[2] = f;
    firePropertyChange("color");
  }
  public void setAlpha(float f) {
    color[3] = f;
    firePropertyChange("color");
  }
  
  protected transient Material material = Material.WHITE_MATERIAL;
  public Material getMaterial() { return material; }
  public void setMaterial(Material m) {
    material = m;
    reBuild();
    firePropertyChange("material");
  }
  public boolean getUseAlpha() { return material.getUseAlpha() || (color[3] != 1f); }
  
  public float getNaturalWidth () { return 0f; }
  public float getNaturalHeight() { return 0f; }
  public float getNaturalDepth () { return 0f; }
  public DimensionWrapper wrapper() {
    return new Box(new Point(0f, 0f, 0f, this), new Point(0f, 0f, 0f, this));
  }
  
  private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
    s.defaultReadObject();
    material = Material.read(s);
  }
  private void writeObject(ObjectOutputStream s) throws IOException {
    s.defaultWriteObject();
    material.write(s);
  }
}
