/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * A multiple particles' colors with colors that change from a color to another.
 * 
 * @author Artiste on the Web
 */

public class FadingParticlesColors extends MultipleParticlesColors {
  private static final long serialVersionUID = 4024693776774441431l;
  /**
   * Create a fading particles colors.
   */
  public FadingParticlesColors() { super(); }
  /**
   * Create a particles colors.
   * @param r the red color component
   * @param g the green color component
   * @param b the blue color component
   * @param a the alpha color component
   */
  public FadingParticlesColors(float r, float g, float b, float a) {
    super(r, g, b, a);
  }
  /**
   * Create a particles colors.
   * @param r the red color component of the initial and final colors
   * @param g the green color component of the initial and final colors
   * @param b the blue color component of the initial and final colors
   * @param a the alpha color component of the initial color
   * @param a2 the alpha color component of the final color
   */
  public FadingParticlesColors(float r, float g, float b, float a, float a2) {
    super(r, g, b, a);
    alpha2 = a2;
  }
  
  /**
   * Clones this fading particles colors.
   * @return the clone
   */
  public Object clone() {
    FadingParticlesColors o = (FadingParticlesColors) super.clone();
    o.alpha2 = alpha2;
    
    return o;
  }
  
  public void advanceParticle(int id, float factor) {
    colors[id * 4 + 3] = color[3] * bunch.lifes.lifes[id] + alpha2 * (1f - bunch.lifes.lifes[id]);
  }
  
  public boolean getUseAlpha() { return true; }
  
  protected float alpha2;
  public float getAlpha2() { return alpha2; }
  public void setAlpha2(float f) {
    alpha2 = f;
    firePropertyChange("alpha2");
  }
}
