/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.fx.particle;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.soya3d.model.*;
import gl4java.*;
import java.io.*;
import java.beans.*;

/**
 * An object that manages particles' colors.
 * 
 * The particles' colors object considers that all particles share the same color. See
 * sub-class for more complex color managements.
 * 
 * @author Artiste on the Web
 */

public class ParticlesColors extends AbstractBean implements Colored, ParticlesStuff {
  private static final long serialVersionUID = -8099948373919505930l;
  /**
   * Create a particles colors.
   */
  public ParticlesColors() { super(); }
  /**
   * Create a particles colors.
   * @param r the red color component
   * @param g the green color component
   * @param b the blue color component
   * @param a the alpha color component
   */
  public ParticlesColors(float r, float g, float b, float a) {
    super();
    color[0] = r;
    color[1] = g;
    color[2] = b;
    color[3] = a;
  }
  
  /**
   * Clones this particles colors.
   * @return the clone
   */
  public Object clone() {
    ParticlesColors o = null;
    try { o = (ParticlesColors) getClass().newInstance(); }
    catch(Exception e) { System.out.println("Cannot clone !"); e.printStackTrace(); }
    System.arraycopy(color, 0, o.color, 0, 4);
    
    return o;
  }
  
  protected ParticlesBunch3D bunch;
  public ParticlesBunch3D getBunch() { return bunch; }
  
  public void initParticle(int id) {
  }
  public void advanceParticle(int id, float factor) {
  }
  public void deleteParticle(int id) {
  }
  
  /**
   * Checks if this particles' colors can use array for a quickier rendering. If true, the
   * defineArray method will correctly define and enable the array.
   * @return true if the particles' colors can use array
   */
  public boolean canUseArray() { return false; }
  /**
   * If canUseArray() is true, define and enable the openGL color array for rendering.
   * Else no-op.
   * @param gl the gl
   * @param glu the glu
   */
  public void defineArray(GLFunc gl, GLUFunc glu) {  }
  
  /**
   * Make the global color current.
   * @param gl the gl
   * @param glu the glu
   */
  public void makeColorCurrent(GLFunc gl, GLUFunc glu) {
    gl.glColor4fv(color);
  }
  /**
   * Make current the color of the particle of the given ID.
   * @param gl the gl
   * @param glu the glu
   */
  public void makeParticleColorCurrent(GLFunc gl, GLUFunc glu, int id) {
  }
  
  // A few properties.
  protected int nbParticles;
  public int getNumberOfParticles() { return nbParticles; }
  public void setNumberOfParticles(int i) {
    nbParticles = i;
    
    firePropertyChange("numberOfParticles");
  }
  
  protected final float[] color = (float[]) Material.WHITE_COLOR.clone();
  public float[] getColor() {	return color; }
  public void setColor(float red, float green, float blue) { setColor(red, green, blue, 1f); }
  public void setColor(float red, float green, float blue, float alpha) {
    color[0] = red;
    color[1] = green;
    color[2] = blue;
    color[3] = alpha;
    firePropertyChange("color");
  }
  public void setColor(float[] c) {
    System.arraycopy(c, 0, color, 0, 4);
    firePropertyChange("color");
  }
  public boolean getUseColor() { return true; }
  public float getRed  () { return color[0]; }
  public float getGreen() { return color[1]; }
  public float getBlue () { return color[2]; }
  public float getAlpha() { return color[3]; }
  public void setRed  (float f) {
    color[0] = f;
    firePropertyChange("color");
  }
  public void setGreen(float f) {
    color[1] = f;
    firePropertyChange("color");
  }
  public void setBlue (float f) {
    color[2] = f;
    firePropertyChange("color");
  }
  public void setAlpha(float f) {
    color[3] = f;
    firePropertyChange("color");
  }
  
  public boolean getUseAlpha() { return color[3] != 1f; }
}
