/*
 * Soya3D
 * Copyright (C) 1999-2000  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

/**
 * Interface for objects that have a color.
 * 
 * Colors are stored in a float[4] array, and each component (red, green, blue and alpha
 * = transparency) should range from 0f and 1f for normal value, but you CAN set it out of
 * this range. For example, a "dark light" can have a color like : { -1f, -1f, -1f, 1f } .
 * 
 * @author Artiste on the Web
 */

public interface Colored {
  /**
   * Gets the color.
   * @return the color
   */
  public float[] getColor();
  /**
   * Sets the color.
   * @param red   the red component
   * @param green the green component
   * @param blue  the blue component
   */
  public void setColor(float red, float green, float blue);
  /**
   * Sets the color.
   * @param red   the red component
   * @param green the green component
   * @param blue  the blue component
   * @param alpha the alpha component
   */
  public void setColor(float red, float green, float blue, float alpha);
  /**
   * Sets the color.
   * @param c an array of 4 color components
   */
  public void setColor(float[] c);

  /**
   * Gets the red component.
   * @return the red component
   */
  public float getRed  ();
  /**
   * Gets the green component.
   * @return the green component
   */
  public float getGreen();
  /**
   * Gets the blue component.
   * @return the blue component
   */
  public float getBlue ();
  /**
   * Gets the alpha component.
   * @return the alpha component
   */
  public float getAlpha();
  /**
   * Sets the red component.
   * @param the new red component
   */
  public void setRed  (float f);
  /**
   * Sets the green component.
   * @param the new green component
   */
  public void setGreen(float f);
  /**
   * Sets the blue component.
   * @param the new blue component
   */
  public void setBlue (float f);
  /**
   * Sets the alpha component.
   * @param the new alpha component
   */
  public void setAlpha(float f);

  /**
   * Checks if this object uses alpha blending and needs to be rendered in a second path.
   * @return true if the alpha component is >= 0! and != 1f .
   */
  public boolean getUseAlpha();
  /**
   * Checks if this object really have a color.
   * @return true if the color is different than soya.soya2d.Material.NO_COLOR
   */
  public boolean getUseColor();
}
