/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Library Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

/**
 * Interface for all objects that have two sides, and one, the other or both sides may be
 * visible or not.
 * 
 * Notice that if a side is hidden (=not visible), it can result in a rendering speed boost.
 * 
 * @author Artiste on the Web
 */

public interface FaceVisibility {
  /**
   * Constant for objects that are non-closed or have no interior and exterior, or if both
   * exterior and interior must be visible.
   */
  public static final int VISIBILITY_ALL = 0;
  /**
   * Constant for objects that are visible only from their exterior.
   */
  public static final int VISIBILITY_EXTERIOR = 1;
  /**
   * Constant for objects that are visible only from their interior.
   */
  public static final int VISIBILITY_INTERIOR = 2;
  /**
   * Constant for objects that must be drawn "as-is", without trying to show only interior,
   * exterior or both. For a face, the visible side is the one where the points turn counter
   * clockwise.
   */
  public static final int VISIBILITY_NO_INTERIOR = 3;
  
  /**
   * Gets this object's visibility.
   * Default is VISIBILITY_ALL .
   * @return a symbolic VISIBILITY_* constant
   */
  public int getVisibility();
  /**
   * Sets this object's visibility.
   * @param i a symbolic VISIBILITY_* constant
   */
  public void setVisibility(int i);
}
