/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.awt.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.editor.*;
import java.beans.*;
import java.lang.reflect.*;
import java.awt.*;
import java.awt.event.*;
	
public class FragmentedShapeCustomizer extends Panel implements Customizer {
  public FragmentedShapeCustomizer() { 
    super(); 
    setLayout(new BorderLayout());
    
    add(rc);
    
    Button b = new Button("Soya GUI editor...");
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        FragmentedShapeGUIEditor.edit(s);
      }
    });
    add(b, BorderLayout.SOUTH);
  }
  
  private RenderingCanvas rc = new RenderingCanvas(150, 100);
  private Environment3D scene;
  private FragmentedShape s;
  public void setObject(Object o) {
    s = (FragmentedShape) o;
    init();
  }
  
  public java.awt.Dimension getPreferredSize() { return new java.awt.Dimension(150, 140); }

  public void addPropertyChangeListener(PropertyChangeListener l) {  }
  public void removePropertyChangeListener(PropertyChangeListener l) {  }

  public void init() {
    if(scene == null) create();
  }
  public void create() {
    scene = new Environment3D();
    scene.setAmbientColor(0.4f, 0.4f, 0.4f);
    scene.add(new Volume3D(s));

    Camera3D c = new Camera3D();
    scene.add(c);
    c.move(0f, 0f, s.getWidth() + s.getHeight());
    rc.setRenderer(c);

    Light3D l = new Light3D();
    scene.add(l);
    l.setColor(1f, 1f, 1f);
    l.setAttenuation(0f, 0.01f, 0f);
    l.move(-1f, 1f, c.getZ());

    s.addPropertyChangeListener(new ChangeRenderer());
  }

  private class ChangeRenderer implements PropertyChangeListener {
    public void propertyChange(PropertyChangeEvent e) { rc.render(); }
  }
}
