/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;

/**
 * A shape element is an element that can be added into a fragmented shape, like a triangle or
 * a quad. They are converted into fragment before being rendered.
 * 
 * The shape element wrap the properties and should be "user-friendly". The fragment is hidden,
 * may be "hackish" but must be quick. Fragment must also use only one material. If a shape
 * element use more than one material, it must be converted into more than one fragment.
 * 
 * See the fragment class.
 * 
 * @author Artiste on the Web
 */

public interface FragmentedShapeElement extends Bean, PreTransformable {
  /**
   * Gets the class of fragment associated with this shape element. The fragment class will
   * describe how to draw the shape element, in openGL code.
   * See the fragment class.
   * @return the fragment class
   */
  public abstract Class getFragmentClass();
  /**
   * Cheks if this shape element can be combined with the given shape element into the same
   * fragment or fragments.
   * It is garanteed that se1.canShareFragmentWith(se2) == se2.canShareFragmentWith(se1) is true.
   * @return true if combinable
   */
  public boolean canShareFragmentWith(FragmentedShapeElement se);

  /**
   * Gets the center of the shape element. It is garanteed that getCenter() == getCenter() .
   * Moving the center should move the ShapeElement (If it is moveable).
   * @return the center position
   */
  public abstract Position getCenter();

  /**
   * Scale the shape element (If it is scaleable).
   * @param f the scaling factor
   */
  public void scale(float f);
  /**
   * Scale the shape element (If it is scaleable).
   * @param fx the x scaling factor
   * @param fy the y scaling factor
   * @param fz the z scaling factor
   */
  public void scale(float fx, float fy, float fz);
}
