/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.soya3d.*;

/**
 * Interface for objects that have light-related properties.
 * 
 * @author Artiste on the Web
 */

public interface Lit {
  /**
   * Checks if this object is lit as if it were smooth. If true, one normal is computed for
   * each point. Else, there is one normal for each face/polygon/...
   * An object should be smooth lit if it is considered as smooth, even if it is approximated
   * by polygon : for example, a cube is not smooth-lit, but a shape with a lot of polygons
   * that approximates a sphere is.
   * Default is often false.
   * @return true if smooth lit
   */
  public boolean isSmoothLit();
  /**
   * Checks if this object is smooth lit.
   * @param b true if smooth lit
   */
  public void setSmoothLit(boolean b);
  
  /**
   * Checks if this object has static lighting effect. If true, it will not be affected by
   * static light (Light3D), only by dynamic light (see soya.soya3d.Light3D.isDynamic(), and
   * soya.soya3d.World3D.toShape() for how to create static lit shape).
   * Default is often false.
   * @return true if static lit
   */
  public boolean isStaticLit();
  
  /**
   * Applies the given lights as static.
   * @param lights the lights (should be dynamic lights, that no longer light static lit
   * object).
   * @param fromCoordSyst the coordinates system of this lit object. May not be required
   * if this lit object is or has already a coordinates system.
   */
  public void applyStaticLighting(Light3D[] lights, CoordSyst fromCoordSyst);
}
