/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.util.*;
import opale.soya.soya3d.*;
import java.util.Iterator;

/**
 * Collects the points and returns a unique PointRecord for each same point.
 * 
 * Usefull class for smoothLit.
 * 
 * @author Artiste on the Web
 */

public class PointsIdentifier {
  private java.util.Collection c = new java.util.Vector();
  public PointRecord searchOrCreate(float x, float y, float z) {
    PointRecord pr;
    for(Iterator i = c.iterator(); i.hasNext(); ) {
      pr = (PointRecord) i.next();
      if(pr.isPointSuitable(x, y, z)) return pr;
    }
    pr = new PointRecord(x, y, z);
    c.add(pr);
    return pr;
  }
  public void computeNormals() {
    for(Iterator i = c.iterator(); i.hasNext(); ) ((PointRecord) i.next()).computeNormal();
  }
}
