/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.editor.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.util.*;
import java.awt.event.*;
import java.beans.*;

class ShapePointHandle3D extends Handle3D implements PropertyChangeListener {
  public ShapePointHandle3D() { super(RED); }
  public ShapePointHandle3D(Position p) {
    this();
    setPoint(p);
  }

  private Position p;
  public Position getPoint() { return p; }
  public Object getEditedObject() { return p; }
  public synchronized void setPoint(Position point) { 
    if(p != null) p.removePropertyChangeListener(this);
    p = point;
    if(p != null) {
      p.addPropertyChangeListener(this);
      move(p);
    }
    firePropertyChange("point"); 
  }
  public void propertyChange(PropertyChangeEvent e) { move(p); }

  protected void doSelection(boolean selected) {  }
  protected void doClick(boolean clicked) {  }
  protected synchronized void doMovement(Cursor3D c, Position position, MouseEvent e) { p.move(position); }
}
