/*
 * Soya3D
 * Copyright (C) 1999-2000  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

/**
 * Interface for all objects that are textured, and have texture coordinates.
 * 
 * @author Artiste on the Web
 */

public interface Textured {
  /**
   * Gets the x texture coordinate.
   * @return the x texture coordinate
   */
  public float getTextureCoordX();
  /**
   * Sets the x texture coordinate.
   * @param newCoord the new x texture coordinate
   */
  public void setTextureCoordX(float newCoord);
  
  /**
   * Gets the y texture coordinate.
   * @return the y texture coordinate
   */
  public float getTextureCoordY();
  /**
   * Sets the y texture coordinate.
   * @param newCoord the new y texture coordinate
   */
  public void setTextureCoordY(float newCoord);
  
  /**
   * Sets the texture coordinates.
   * @param newCoordX the new x texture coordinate
   * @param newCoordY the new y texture coordinate
   */
  public void setTextureCoords(float newCoordX, float newCoordY);
}
