/*
 * Soya3D
 * Copyright (C) 1999-2000  Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.util.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import opale.soya.awt.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;

class TexturedGUIEditor extends java.awt.Frame implements PropertyChangeListener, FocusListener, KeyListener, MouseListener, MouseMotionListener {
  public TexturedGUIEditor(Textured t, Texture tex) { this(t, tex, null); }
  public TexturedGUIEditor(Textured t, Texture tex, Lockable l) {
    super("soya GUI textured editor");
    textured = t;
    texture  = tex;
    lock = l;
    AbstractBean.addPropertyChangeListenerToBean(t, this);
    
    setLayout(new BorderLayout());

    Camera3D camera = new Camera3D();
    scene.add(camera);
    scene.setBackgroundImage(texture);
    //scene.setAmbientColor(.5f, 0f, 0f);
    c.setRenderer(camera);
    c.addMouseListener(this);
    c.addMouseMotionListener(this);
    add(c);
    
    Panel p = new Panel(new GridLayout(2,2));
    add(p, BorderLayout.SOUTH);

    p.add(new Label("Texture coordinate X", Label.RIGHT));
    tx = new TextField(Float.toString(textured.getTextureCoordX()));
    tx.addFocusListener(this);
    tx.addKeyListener(this);
    p.add(tx);

    p.add(new Label("Texture coordinate Y", Label.RIGHT));
    ty = new TextField(Float.toString(textured.getTextureCoordY()));
    ty.addFocusListener(this);
    ty.addKeyListener(this);
    p.add(ty);
    
    setSize(320, 300);
    
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        AbstractBean.removePropertyChangeListenerToBean(textured, TexturedGUIEditor.this);
        //c.dispose();
        dispose();
      }
    });
  }
  
  private Textured textured;
  private Texture  texture ;
  private TextField tx;
  private TextField ty;
  private Lockable lock;
  private boolean processEvents = true;

  public void focusGained(FocusEvent e) {  }
  public void focusLost(FocusEvent e) { changed(); }
  public void keyPressed(KeyEvent e) {  }
  public void keyTyped(KeyEvent e) {  }
  public void keyReleased(KeyEvent e) {
    if (e.getKeyCode() == KeyEvent.VK_ENTER) changed();
  }
  private synchronized void changed() {
    if(!processEvents) return;
    processEvents = false;
    try {
      if(lock != null) lock.lock();
      try { textured.setTextureCoords(Float.parseFloat(tx.getText()), Float.parseFloat(ty.getText())); }
      catch(Exception e) { e.printStackTrace(); }
      finally { if(lock != null) lock.unlock(); }
    }
    catch(Exception e) { System.out.println("Can't set the texture coords!"); e.printStackTrace(); }
    processEvents = true;
  }
  public synchronized void propertyChange(PropertyChangeEvent e) {
    if(!processEvents) return;
    processEvents = false;
    if("textureCoordX".equals(e.getPropertyName())) tx.setText(Float.toString(textured.getTextureCoordX()));
    if("textureCoordY".equals(e.getPropertyName())) ty.setText(Float.toString(textured.getTextureCoordY()));
    processEvents = true;
  }
  
  private RenderingCanvas c = new RenderingCanvas(300, 200);
  private Environment3D scene = new Environment3D();
    
  public void mouseClicked(MouseEvent e) {  }
  public void mouseEntered(MouseEvent e) {  }
  public void mouseExited(MouseEvent e) {  }
  public void mouseReleased(MouseEvent e) {  }
  public void mouseMoved(MouseEvent e) {  }
  public void mousePressed(MouseEvent e) { mouseDragged(e); }
  public void mouseDragged(MouseEvent e) {
    processEvents = false;
    float x = ((float) e.getX()) / ((float) c.getWidth()), y =((float) e.getY()) / ((float) c.getHeight());
    if(x < 0f) x = 0f;
    if(x > 1f) x = 1f;
    if(y < 0f) y = 0f;
    if(y > 1f) y = 1f;
    if(lock != null) lock.lock();
    textured.setTextureCoords(x, y);
    if(lock != null) lock.unlock();
    tx.setText(Float.toString(textured.getTextureCoordX()));
    ty.setText(Float.toString(textured.getTextureCoordY()));
    processEvents = true;
  }
}
