/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.soya2d.*;
import opale.soya.soya3d.*;
import java.io.*;

/**
 * A face that has three points. This face element can be used to create polygonal fragmented
 * shape.
 * 
 * @author Artiste on the Web
 */

public class Triangle extends Face {
  /**
   * Creates a new triangle.
   */
  public Triangle() { super(); }
  /**
   * Creates a new triangle, with the given points.
   * @param p the array of points (at least three)
   */
  public Triangle(Position[] p) { this(p, null); }
  /**
   * Creates a new triangle, with the given points and material.
   * @param p the array of points (at least three)
   * @param m the material
   */
  public Triangle(Position[] p, Material m) { super(p, m); }
  /**
   * Creates a new triangle, from the given array of points, material, visibility and lit.
   * @param p the points
   * @param m the material
   * @param newVisibility the visibility
   * @param newSmoothLit true for smooth-lighting
   */
  public Triangle(Position[] p, Material m, int newVisibility, boolean newSmoothLit) { super(p, m, newVisibility, newSmoothLit); }
  /**
   * Creates a new face, from the given array of points, material, visibility, lit and hidden.
   * @param ps the points
   * @param m the material
   * @param newVisibility the visibility
   * @param newSmoothLit true for smooth-lighting
   * @param newHidden true for hidden
   */
  public Triangle(Position[] ps, Material m, int newVisibility, boolean newSmoothLit, boolean newHidden) { super(ps, m, newVisibility, newSmoothLit, newHidden); }
  /**
   * Creates a new face, from the given array of points, material, visibility, lit and hidden.
   * @param ps the points
   * @param m the material
   * @param newVisibility the visibility
   * @param newSmoothLit true for smooth-lighting
   * @param newStaticLit true if static-lit
   * @param newHidden true for hidden
   */
  public Triangle(Position[] ps, Material m, int newVisibility, boolean newSmoothLit, boolean newStaticLit, boolean newHidden) { super(ps, m, newVisibility, newSmoothLit, newStaticLit, newHidden); }
  /**
   * Creates a new triangle, with the given points.
   * @param p1 the first point
   * @param p2 the second point
   * @param p3 the third point
   */
  public Triangle(Position p1, Position p2, Position p3) { this(p1, p2, p3, null); }
  /**
   * Creates a new triangle, with the given points and material.
   * @param p1 the first point
   * @param p2 the second point
   * @param p3 the third point
   * @param m the material
   */
  public Triangle(Position p1, Position p2, Position p3, Material m) { this(p1, p2, p3, m, FaceVisibility.VISIBILITY_ALL, false); }
  /**
   * Creates a new triangle, with the given points and material, visibility and lit.
   * @param p1 the first point
   * @param p2 the second point
   * @param p3 the third point
   * @param m the material
   * @param newVisibility the visibility
   * @param newSmoothLit true for smooth-lighting
   */
  public Triangle(Position p1, Position p2, Position p3, Material m, int newVisibility, boolean newSmoothLit) { super(createArray(p1, p2, p3), m); }
  private static final Position[] createArray(Position p1, Position p2, Position p3) { // Avoid a java foolish error.
    Position[] a = { p1, p2, p3 };
    return a;
  }
  
  public Object clone() {
    Position[] ps = getPoints();
    return new Triangle((Position) ps[0].clone(), (Position) ps[1].clone(), (Position) ps[2].clone(), material, visibility, smoothLit);
  }

  /**
   * Gets the number of points in a triangle.
   * @return 3
   */
  public int getNumberOfPoints() { return 3; }

  public Class getFragmentClass() {
    try { return Class.forName("opale.soya.soya3d.model.TrianglesFragment"); }
    catch (Exception e) { System.out.println("Triangle : can't find TrianglesFragment class"); }
    return null;
  }

  public float getPoint_0_X() { return getPoint(0).getX();  }
  public void  setPoint_0_X(float f) { getPoint(0).setX(f); }
  public float getPoint_0_Y() { return getPoint(0).getY();  }
  public void  setPoint_0_Y(float f) { getPoint(0).setY(f); }
  public float getPoint_0_Z() { return getPoint(0).getZ();  }
  public void  setPoint_0_Z(float f) { getPoint(0).setZ(f); }

  public float getPoint_1_X() { return getPoint(1).getX();  }
  public void  setPoint_1_X(float f) { getPoint(1).setX(f); }
  public float getPoint_1_Y() { return getPoint(1).getY();  }
  public void  setPoint_1_Y(float f) { getPoint(1).setY(f); }
  public float getPoint_1_Z() { return getPoint(1).getZ();  }
  public void  setPoint_1_Z(float f) { getPoint(1).setZ(f); }

  public float getPoint_2_X() { return getPoint(2).getX();  }
  public void  setPoint_2_X(float f) { getPoint(2).setX(f); }
  public float getPoint_2_Y() { return getPoint(2).getY();  }
  public void  setPoint_2_Y(float f) { getPoint(2).setY(f); }
  public float getPoint_2_Z() { return getPoint(2).getZ();  }
  public void  setPoint_2_Z(float f) { getPoint(2).setZ(f); }
}
