/*
 * Soya3D
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package opale.soya.soya3d.model;

import opale.soya.*;
import opale.soya.editor.*;

/**
 * A bean editor for the visibility property of FaceVisibility.
 * 
 * @author Artiste on the Web
 */

public class VisibilityPropertyEditor extends TaggedPropertyEditor {
  public VisibilityPropertyEditor() {
    super();
    
    addTag("All faces visible", FaceVisibility.VISIBILITY_ALL        );
    addTag("Exterior visible" , FaceVisibility.VISIBILITY_EXTERIOR   );
    addTag("Interior visible" , FaceVisibility.VISIBILITY_INTERIOR   );
    addTag("Non-closed"       , FaceVisibility.VISIBILITY_NO_INTERIOR);
  }
}
