/*
 * Soya3D tutorial
 * Copyright (C) 1999-2000 Jean-Baptiste LAMY (Artiste on the web)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
This tutorials assume you already know java programming, 
but you don't need any knowledge about 3D programming.
Here math stuff like matrix,... are useless.

The lessons 0?? (1, 2, ... : below 100) are about basic stuff. The lessons 1?? (101, 102...)
are about special stuff : special effect, animation,... those lessons are less important than
the first one, but not always harder and sometime more fun :-)

Please forget about my english... :-)
*/

/*
Lesson 1 : smaller program : display a shape
This is the smaller soya program you can done.
It just set up all the things and draw a cube from a file in a window.
The cube is loaded from the file cube.shape . You can create such files
with soya code, or with the soya GUI editor !!!!!!!!
*/

package opale.soya.tutorial;

/*
First, import a few soya packages.
*/
import opale.soya.*;              // contains the basic stuff (initialization,...).
import opale.soya.awt.*;          // contains the GUI stuff (RenderingCanvas, RenderingFrame,...).
import opale.soya.soya2d.*;       // contains the 2D stuff (Texturing and Material).
import opale.soya.soya3d.*;       // contains the 3D stuff (A lot of things).
import opale.soya.soya3d.model.*; // contains the modeling stuff, for the cube (Shape,...).

import java.net.*;

/*
The Lesson1 is a window with a 3D drawing.
We need 2 things for that : a RenderingSurface (where to draw on the screen?)
and a Renderer (from where to draw in the 3D scene?). Basic rendering surfaces are
RenderingFrame or RenderingCanvas. Here we'll use a RenderingFrame. Basic renderer
is a camera (Camera3D).
*/
public class Lesson1 extends RenderingFrame {
  /*
  Create a Lesson1 object and show it.
  */
  public static void main(String[] args) {
    (new Lesson1()).setVisible(true);
  }
  
  /*
  Build the scene.
  */
  public Lesson1() {
    /*
    Set the size of the view.
    */
    super(320, 200);
    
    /*
    Initializes soya with this RenderingSurface (a RenderingFrame is a RenderingSurface) as root.
    The root RenderingSurface should exist all your program's lifetime. It is used to store data.
    This is the unique initialization needed. Soya and gl4java will automatically do everything else.
    */
    Soya.init(this);
    
    /*
    Creates a new World3D. It will be our scene object.
    A world is a 3D element that can contain other element.
    All the 3D elements have the -3D suffix at their class name,
    and they extends the Element3D class.
    */
    scene = new World3D();
    
    /*
    Sets the path from witch Shape object will be loaded. Here it is the path that contains
    this class file.
    */
    Shape.path = getClass().getResource("").getFile();
    /*
    Gets from Shape.path the Shape named "cube".
    The shape object just describe how to draw a cube.
    If this shape is already loaded, the get method always return the same object. Use the load method if you don't want that.
    You can use Shape.load(fileName) if you want to load it from any other path.
    */
    Shape cube = null;
    try { cube = Shape.get("test"); }
    catch(Exception e) { e.printStackTrace(); }
    
    /*
    Creates a new Volume3D. It will be the cube object.
    A volume is a 3D element that has a shape.
    */
    Volume3D volume = new Volume3D();
    /*
    Sets the shape of this volume to a cube.
    The same shape can be used by more than one volume
    (or any other Shapeable object. Shapeable is the interface of object that have a shape.
    Notice that world extends volume, so it is also Shapeable.).
    */
    volume.setShape(cube);
    /*
    Adds our volume into the scene. A given Element3D can be added only in one world at a time.
    However, you can remove it and re-add it many time.
    */
    scene.add(volume);
    
    /*
    Creates a new Light3D. It is required in order to see something.
    A light is a 3D element. Here we use the default color (white) and kind of light (point).
    */
    Light3D light = new Light3D();
    /*
    Adds our light into the scene.
    */
    scene.add(light);
    /*
    Positions the light. The new position is given in the parent world coordinates (here, world).
    (Don't worry about coordinates converting, because soya can perform them automatically.)
    */
    light.move(-.6f, .1f, .7f);
    /*
    Defines the attenuation factors for the light.
    */
    light.setAttenuation(0f, .0001f, 0f);
    
    /*
    Creates a new Camera3D. It will be our Renderer.
    A camera is a 3D element.
    */
    Camera3D camera = new Camera3D();
    /*
    Adds our camera into the scene.
    */
    scene.add(camera);
    /*
    Positions the camera.
    */
    camera.move(-1f, -.7f, 2f);
    
    /*
    Sets the renderer for our RenderingSurface (remember, Lesson1 extends RenderingFrame,
    witch is a RenderingSurface).
    */
    this.setRenderer(camera);
    
    /*
    Refresh the view.
    */
    render();
    
    /*
    Every thing is done!!!!!!!!!!!!, and without any matrix!!!!!!!!!!!!!!!!!!!!!!!
    
    Rather straightforward, no ?
    
    The main object of soya3D are Element3D and all its sub-classes. Look at the classgraph
    file (in this directory) ! There is lots of them !
    A very important class is GraphicalElement3D. It corresponds to all graphical element, like
    all the ones we have used in this first lesson. A graphical element has a position (with
    x, y, z properties and move,... methods), an orientation (with rotate, lookAt,... methods)
    and dimensions (with width, height, depth properties and scale,... methods).
    */
  }
  
  /*
  Keeps a reference to the scene, in order to avoid it to be garbage-collected.
  */
  private World3D scene;
}
